/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.database.migrations.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.DatabaseType;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.SqlConnectionProvider;
import net.shortninja.staffplus.core.common.exceptions.DatabaseException;

@IocBean(conditionalOnProperty="storage.type=sqlite")
public class SqlLiteConnectionProvider
implements SqlConnectionProvider {
    private static final Object LOCK = new Object();
    private final StaffPlusPlus staffPlusPlus;
    private Connection connection;

    public SqlLiteConnectionProvider(@InjectTubingPlugin StaffPlusPlus staffPlusPlus) {
        this.staffPlusPlus = staffPlusPlus;
    }

    @Override
    public Connection getConnection() {
        Object object = LOCK;
        synchronized (object) {
            String url = "jdbc:sqlite:plugins/StaffPlusPlus/staff.db";
            try {
                Class.forName("org.sqlite.JDBC");
                long totalWaitTime = 0L;
                while (this.connection != null && !this.connection.isClosed()) {
                    Thread.sleep(1L);
                    if (++totalWaitTime <= 3000L) continue;
                    this.connection.close();
                    break;
                }
                this.connection = DriverManager.getConnection(url);
                return this.connection;
            }
            catch (ClassNotFoundException | InterruptedException | SQLException e) {
                throw new DatabaseException("Failed to connect to the database", e);
            }
        }
    }

    @Override
    public DataSource getDatasource() {
        return null;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQLITE;
    }
}

