/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.database.migrations.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperties;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.DatabaseType;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.SqlConnectionProvider;
import net.shortninja.staffplus.core.common.exceptions.DatabaseException;
import net.shortninja.staffplus.libs.com.zaxxer.hikari.HikariConfig;
import net.shortninja.staffplus.libs.com.zaxxer.hikari.HikariDataSource;

@IocBean(conditionalOnProperty="storage.type=mysql")
@ConfigProperties(value="storage.mysql")
public class MySQLConnectionProvider
implements SqlConnectionProvider {
    @ConfigProperty(value="host")
    private String host;
    @ConfigProperty(value="user")
    private String user;
    @ConfigProperty(value="database")
    private String database;
    @ConfigProperty(value="password")
    private String password;
    @ConfigProperty(value="port")
    private int port;
    @ConfigProperty(value="ssl-enabled")
    private boolean sslEnabled;
    @ConfigProperty(value="max-pool-size")
    private int maxPoolSize;
    private HikariDataSource datasource;

    @Override
    public DataSource getDatasource() {
        if (this.datasource == null) {
            this.getDataSource();
        }
        return this.datasource;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.MYSQL;
    }

    @Override
    public Connection getConnection() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            return this.getDatasource().getConnection();
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DatabaseException("Failed to connect to the database", e);
        }
    }

    private void getDataSource() {
        if (this.datasource == null) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?autoReconnect=true&useSSL=" + this.sslEnabled + "&allowMultiQueries=true&allowPublicKeyRetrieval=true");
            config.setUsername(this.user);
            config.setPassword(this.password);
            config.setMaximumPoolSize(this.maxPoolSize);
            config.setLeakDetectionThreshold(5000L);
            config.setAutoCommit(true);
            config.setDriverClassName("com.mysql.jdbc.Driver");
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            this.datasource = new HikariDataSource(config);
        }
    }
}

