/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.database.migrations.common;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.Migration;
import net.shortninja.staffplus.core.common.Constants;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;

@IocBean
@IocMultiProvider(value={Migration.class})
public class V69_MigrateNotesToSqlMigration
implements Migration {
    private static final String DATA_YML = "data.yml";
    private final Options options;

    public V69_MigrateNotesToSqlMigration(Options options) {
        this.options = options;
    }

    @Override
    public List<String> getStatements(Connection connection) {
        ArrayList<String> insertStatements = new ArrayList<String>();
        File file = new File(StaffPlusPlus.get().getDataFolder(), DATA_YML);
        if (!file.exists()) {
            return Collections.emptyList();
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        Set keys = configuration.getKeys(false);
        keys.stream().filter(key -> configuration.contains(key + ".notes")).forEach(key -> {
            String targetName = this.getPlayerName(UUID.fromString(key)).orElse("Unknown");
            List notes = configuration.getStringList(key + ".notes");
            notes.stream().map(note -> this.buildInsertNoteStatement((String)key, targetName, (String)note, this.options.serverName)).forEach(insertStatements::add);
            configuration.set(key + ".notes", null);
        });
        return insertStatements;
    }

    private String buildInsertNoteStatement(String key, String targetName, String note, String serverName) {
        return String.format("INSERT INTO sp_player_notes (note, target_name, target_uuid, noted_by_name, noted_by_uuid, creation_timestamp, server_name) VALUES ('%s', '%s', '%s', '%s', '%s', %s, '%s');", note.replace("'", "''"), targetName, key, "Console", Constants.CONSOLE_UUID.toString(), System.currentTimeMillis(), serverName.replace("'", "''"));
    }

    public Optional<String> getPlayerName(UUID uuid) {
        return Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> p.getUniqueId().equals(uuid)).findFirst().map(OfflinePlayer::getName);
    }

    @Override
    public int getVersion() {
        return 69;
    }
}

