/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.database.migrations.common;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.Migration;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.QueryBuilderFactory;
import net.shortninja.staffplus.core.common.utils.DatabaseUtil;
import net.shortninja.staffplus.core.domain.player.PlayerManager;

@IocBean
@IocMultiProvider(value={Migration.class})
public class V52_AddNamesToBanTableMigration
implements Migration {
    private final PlayerManager playerManager;
    private final QueryBuilderFactory query;

    public V52_AddNamesToBanTableMigration(PlayerManager playerManager, QueryBuilderFactory query) {
        this.playerManager = playerManager;
        this.query = query;
    }

    @Override
    public List<String> getStatements(Connection connection) {
        String addPlayerNameColumn = "ALTER TABLE sp_banned_players ADD COLUMN player_name VARCHAR(32) NOT NULL DEFAULT 'Unknown';";
        String addIssuerNameColumn = "ALTER TABLE sp_banned_players ADD COLUMN issuer_name VARCHAR(32) NOT NULL DEFAULT 'Unknown';";
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(addPlayerNameColumn);
        statements.add(addIssuerNameColumn);
        statements.addAll(DatabaseUtil.createMigrateNameStatements(connection, this.playerManager, this.query, "sp_banned_players", "player_name", "player_uuid"));
        statements.addAll(DatabaseUtil.createMigrateNameStatements(connection, this.playerManager, this.query, "sp_banned_players", "issuer_name", "issuer_uuid"));
        return statements;
    }

    @Override
    public int getVersion() {
        return 52;
    }
}

