/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.config.migrators;

import java.util.LinkedHashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.migrators.StaffPlusPlusConfigMigrator;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationFile;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;
import net.shortninja.staffplus.core.domain.actions.ActionRunStrategy;

public class WarningCommandsMigrator
implements StaffPlusPlusConfigMigrator {
    @Override
    public void migrate(List<ConfigurationFile> configs) {
        FileConfiguration config = this.getConfig(configs, "config");
        List actions = (List)config.get("warnings-module.actions");
        if (actions != null) {
            actions.forEach(this::migrateChannel);
        }
    }

    private void migrateChannel(LinkedHashMap<String, Object> action) {
        String command = (String)action.get("command");
        action.put("command", command.replace("%player%", "%target%"));
        Object rollbackCommand = action.get("rollback-command");
        if (rollbackCommand instanceof String) {
            LinkedHashMap<String, String> rollbackCommandConfig = new LinkedHashMap<String, String>();
            rollbackCommandConfig.put("command", ((String)rollbackCommand).replace("%player%", "%target%"));
            action.put("rollback-command", rollbackCommandConfig);
        }
        if (action.containsKey("run-strategy")) {
            ActionRunStrategy runStrategy = ActionRunStrategy.valueOf((String)action.get("run-strategy"));
            if (runStrategy != ActionRunStrategy.ALWAYS) {
                action.put("target", "target");
                action.put("target-run-strategy", runStrategy.name());
            }
            action.remove("run-strategy");
        }
    }
}

