/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.config.migrators;

import java.util.ArrayList;
import java.util.List;
import net.shortninja.staffplus.core.application.config.migrators.StaffPlusPlusConfigMigrator;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationFile;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.ConfigurationSection;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;

public class StaffModesMigrator
implements StaffPlusPlusConfigMigrator {
    private void migrateModule(FileConfiguration defaultConfig, FileConfiguration modulesConfig, String from, String to) {
        ConfigurationSection configurationSection = defaultConfig.getConfigurationSection(from);
        if (configurationSection != null) {
            modulesConfig.set(to, configurationSection);
        }
    }

    @Override
    public void migrate(List<ConfigurationFile> configs) {
        FileConfiguration defaultConfig = this.getConfig(configs, "config");
        FileConfiguration modulesConfig = this.getConfig(configs, "staffmode-modules");
        FileConfiguration modesConfig = this.getConfig(configs, "staffmode-modes");
        FileConfiguration customModulesConfig = this.getConfig(configs, "staffmode-custom-modules");
        if (defaultConfig.contains("staff-mode")) {
            this.migrateModule(defaultConfig, modesConfig, "staff-mode", "modes.default");
            ArrayList<String> guiModules = new ArrayList<String>();
            this.migrateGuiModules(guiModules, modulesConfig);
            this.migrateCustomGuiModules(guiModules, customModulesConfig);
            modesConfig.set("modes.default.gui", guiModules);
            ConfigurationSection customGuis = defaultConfig.getConfigurationSection("staff-mode.custom-gui");
            if (customGuis != null) {
                customGuis.getKeys(false).forEach(key -> this.migrateModule(defaultConfig, modesConfig, "staff-mode.custom-gui." + key, "modes." + key));
            }
            modesConfig.set("modes.default.custom-gui", null);
            defaultConfig.set("staff-mode", null);
        }
    }

    private void migrateGuiModules(List<String> guiModules, FileConfiguration modulesConfig) {
        ConfigurationSection modules = modulesConfig.getConfigurationSection("modules");
        this.migrateGuiModules(guiModules, modules);
    }

    private void migrateCustomGuiModules(List<String> guiModules, FileConfiguration customModulesConfig) {
        ConfigurationSection modules = customModulesConfig.getConfigurationSection("custom-modules");
        this.migrateGuiModules(guiModules, modules);
    }

    private void migrateGuiModules(List<String> guiModules, ConfigurationSection modules) {
        if (modules == null) {
            return;
        }
        for (String key : modules.getKeys(false)) {
            boolean enabled = modules.getConfigurationSection(key).getBoolean("enabled");
            if (!enabled) continue;
            int slot = modules.getConfigurationSection(key).getInt("slot");
            guiModules.add(key + ":" + slot);
        }
    }
}

