/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.config.migrators;

import java.util.List;
import java.util.function.Function;
import net.shortninja.staffplus.core.application.config.migrators.StaffPlusPlusConfigMigrator;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.files.ConfigurationFile;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.file.FileConfiguration;

public class ReportMessagesMigrator
implements StaffPlusPlusConfigMigrator {
    @Override
    public void migrate(List<ConfigurationFile> config) {
        List<FileConfiguration> langFiles = this.getLangFiles(config);
        for (FileConfiguration langFile : langFiles) {
            this.replace(langFile, "reported", s -> s.replace("%target%", "%culprit%"));
            this.replace(langFile, "reported-staff", s -> s.replace("%player%", "%culprit%").replace("%target%", "%reporter%"));
            this.replace(langFile, "reports-cleared", s -> s.replace("%target%", "%culprit%"));
            this.replace(langFile, "reported-staff", s -> s.replace("%player%", "%culprit%").replace("%target%", "%reporter%"));
            this.migrate(langFile, "reports-prefix", "prefix");
            this.migrate(langFile, "reported", "reporter.report-created");
            this.migrate(langFile, "reported-staff", "report-created-notification");
            this.migrate(langFile, "reports-cleared", "reports-cleared");
            this.migrate(langFile, "reports-list-start", "reports-list-start");
            this.migrate(langFile, "reports-list-entry", "reports-list-entry");
            this.migrate(langFile, "reports-list-end", "reports-list-end");
        }
    }

    private void replace(FileConfiguration langFile, String path, Function<String, String> f) {
        String string;
        if (langFile.contains(path) && (string = langFile.getString(path)) != null) {
            langFile.set(path, f.apply(string));
        }
    }

    private void migrate(FileConfiguration langFile, String path, String newPath) {
        if (langFile.contains(path)) {
            langFile.set("reports." + newPath, langFile.getString(path));
            langFile.set(path, null);
        }
    }
}

