/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.config.messages;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shortninja.staffplus.core.application.config.MessageMultiLineTransformer;
import net.shortninja.staffplus.core.application.config.messages.MessageSenderFactory;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.common.JsonSenderService;
import net.shortninja.staffplus.core.common.PlaceholderService;
import net.shortninja.staffplus.core.common.gui.gradient.GradientColorProcessor;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.Strings;
import net.shortninja.staffplusplus.session.SppInteractor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@IocBean
public class Messages {
    public static final List<String> LANG_FILES = Arrays.asList("lang_de", "lang_en", "lang_es", "lang_fr", "lang_hr", "lang_hu", "lang_it", "lang_lt", "lang_pl", "lang_nl", "lang_no", "lang_pt", "lang_sv", "lang_zh", "lang_id", "lang_ru");
    public static final String NO_PREFIX = "[NO_PREFIX]";
    public final String LONG_LINE = "&m" + Strings.repeat('-', 48);
    private final Pattern hexColorPattern = Pattern.compile("#[a-fA-F0-9]{6}");
    private final JsonSenderService jsonSenderService;
    private final MessageSenderFactory messageSenderFactory;
    @ConfigProperty(value="%lang%:general-prefix")
    public String prefixGeneral;
    @ConfigProperty(value="%lang%:protect-prefix")
    public String prefixProtect;
    @ConfigProperty(value="%lang%:warnings-prefix")
    public String prefixWarnings;
    @ConfigProperty(value="%lang%:trace-prefix")
    public String prefixTrace;
    @ConfigProperty(value="%lang%:investigations-prefix")
    public String prefixInvestigations;
    @ConfigProperty(value="%lang%:staff-list-start")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> staffListStart;
    @ConfigProperty(value="%lang%:staff-list-end")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> staffListEnd;
    @ConfigProperty(value="%lang%:staff-list-member")
    public String staffListMember;
    @ConfigProperty(value="%lang%:revived-staff")
    public String revivedStaff;
    @ConfigProperty(value="%lang%:revived-user")
    public String revivedUser;
    @ConfigProperty(value="%lang%:command-blocked")
    public String commandBlocked;
    @ConfigProperty(value="%lang%:mode-command-blocked")
    public String modeCommandBlocked;
    @ConfigProperty(value="%lang%:on-cooldown")
    public String commandOnCooldown;
    @ConfigProperty(value="%lang%:no-permission")
    public String noPermission;
    @ConfigProperty(value="%lang%:player-offline")
    public String playerOffline;
    @ConfigProperty(value="%lang%:player-not-registered")
    public String playerNotRegistered = "This player does not exist";
    @ConfigProperty(value="%lang%:invalid-arguments")
    public String invalidArguments;
    @ConfigProperty(value="%lang%:only-players")
    public String onlyPlayers;
    @ConfigProperty(value="%lang%:no-found")
    public String noFound;
    @ConfigProperty(value="%lang%:type-input")
    public String typeInput;
    @ConfigProperty(value="%lang%:input-accepted")
    public String inputAccepted;
    @ConfigProperty(value="%lang%:enabled")
    public String enabled;
    @ConfigProperty(value="%lang%:disabled")
    public String disabled;
    @ConfigProperty(value="%lang%:reports.prefix")
    public String prefixReports;
    @ConfigProperty(value="%lang%:reports.reporter.report-created")
    public String reporterReportCreated;
    @ConfigProperty(value="%lang%:reports.reporter.report-player-created")
    public String reporterReportPlayerCreated;
    @ConfigProperty(value="%lang%:reports.reporter.report-rejected")
    public String reporterReportRejected;
    @ConfigProperty(value="%lang%:reports.reporter.report-resolved")
    public String reporterReportResolved;
    @ConfigProperty(value="%lang%:reports.reporter.report-accepted")
    public String reporterReportAccepted;
    @ConfigProperty(value="%lang%:reports.reporter.view-reports-button")
    public String reporterViewReportsButton;
    @ConfigProperty(value="%lang%:reports.reporter.view-reports-button-tooltip")
    public String reporterViewReportsButtonTooltip;
    @ConfigProperty(value="%lang%:reports.report-created-notification")
    public String reportCreatedNotification;
    @ConfigProperty(value="%lang%:reports.report-player-created-notification")
    public String reportCulpritCreatedNotification;
    @ConfigProperty(value="%lang%:reports.report-reopened-notification")
    public String reportReopenedNotification;
    @ConfigProperty(value="%lang%:reports.report-deleted-notification")
    public String reportDeletedNotification;
    @ConfigProperty(value="%lang%:reports.report-closed-notification")
    public String reportClosedNotification;
    @ConfigProperty(value="%lang%:reports.report-accepted-notification")
    public String reportAcceptedNotification;
    @ConfigProperty(value="%lang%:reports.reports-cleared")
    public String reportsCleared;
    @ConfigProperty(value="%lang%:reports.reports-list-entry")
    public String reportsListEntry;
    @ConfigProperty(value="%lang%:reports.status.REJECTED")
    public String reportRejectedStatus;
    @ConfigProperty(value="%lang%:reports.status.RESOLVED")
    public String reportResolvedStatus;
    @ConfigProperty(value="%lang%:reports.status.OPEN")
    public String reportOpenStatus;
    @ConfigProperty(value="%lang%:reports.status.IN_PROGRESS")
    public String reportInProgressStatus;
    @ConfigProperty(value="%lang%:reports.reports-list-start")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> reportsListStart;
    @ConfigProperty(value="%lang%:reports.reports-list-end")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> reportsListEnd;
    @ConfigProperty(value="%lang%:warned")
    public String warned;
    @ConfigProperty(value="%lang%:warned-announcement")
    public String warnedAnnouncement;
    @ConfigProperty(value="%lang%:warn")
    public String warn;
    @ConfigProperty(value="%lang%:warnings-notify")
    public String warningsNotify;
    @ConfigProperty(value="%lang%:warnings-list-entry")
    public String warningsListEntry;
    @ConfigProperty(value="%lang%:warnings-list-start")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> warningsListStart;
    @ConfigProperty(value="%lang%:warnings-list-end")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> warningsListEnd;
    @ConfigProperty(value="%lang%:infraction-item")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> infractionItem;
    @ConfigProperty(value="%lang%:chat-clear-line")
    public String chatClearLine;
    @ConfigProperty(value="%lang%:chat-cleared")
    public String chatCleared;
    @ConfigProperty(value="%lang%:chat-toggled")
    public String chatToggled;
    @ConfigProperty(value="%lang%:chat-prevented")
    public String chatPrevented;
    @ConfigProperty(value="%lang%:chat-slowed")
    public String chatSlowed;
    @ConfigProperty(value="%lang%:chatting-fast")
    public String chattingFast;
    @ConfigProperty(value="%lang%:blacklist-chat-format")
    public String blacklistChatFormat;
    @ConfigProperty(value="%lang%:total-vanish")
    public String totalVanish;
    @ConfigProperty(value="%lang%:list-vanish")
    public String listVanish;
    @ConfigProperty(value="%lang%:player-vanish")
    public String playerVanish;
    @ConfigProperty(value="%lang%:vanish-enabled")
    public String vanishEnabled;
    @ConfigProperty(value="%lang%:alert-changed")
    public String alertChanged;
    @ConfigProperty(value="%lang%:alerts-name")
    public String alertsName;
    @ConfigProperty(value="%lang%:alerts-chat-phrase-detected")
    public String alertsChatPhraseDetected;
    @ConfigProperty(value="%lang%:alerts-command-detected")
    public String alertsCommandDetected;
    @ConfigProperty(value="%lang%:alerts-mention")
    public String alertsMention;
    @ConfigProperty(value="%lang%:alerts-xray")
    public String alertsXray;
    @ConfigProperty(value="%lang%:alerts-blacklist")
    public String alertsBlacklist;
    @ConfigProperty(value="%lang%:mode-status")
    public String modeStatus;
    @ConfigProperty(value="%lang%:mode-original-location")
    public String modeOriginalLocation;
    @ConfigProperty(value="%lang%:mode-random-teleport")
    public String modeRandomTeleport;
    @ConfigProperty(value="%lang%:mode-not-enough-players")
    public String modeNotEnoughPlayers;
    @ConfigProperty(value="%lang%:mode-fly-enabled")
    public String modeFlightEnabled;
    @ConfigProperty(value="%lang%:mode-fly-disabled")
    public String modeFlightDisabled;
    @ConfigProperty(value="%lang%:freeze")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> freeze;
    @ConfigProperty(value="%lang%:unfrozen")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> unfrozen;
    @ConfigProperty(value="%lang%:staff-froze")
    public String staffFroze;
    @ConfigProperty(value="%lang%:staff-unfroze")
    public String staffUnfroze;
    @ConfigProperty(value="%lang%:freeze-logout")
    public String freezeLogout;
    @ConfigProperty(value="%lang%:freeze-title")
    public String freezeTitle;
    @ConfigProperty(value="%lang%:freeze-subtitle")
    public String freezeSubtitle;
    @ConfigProperty(value="%lang%:cps-start")
    public String cpsStart;
    @ConfigProperty(value="%lang%:cps-finish-normal")
    public String cpsFinishNormal;
    @ConfigProperty(value="%lang%:cps-finish-max")
    public String cpsFinishMax;
    @ConfigProperty(value="%lang%:examine-food")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> examineFood;
    @ConfigProperty(value="%lang%:examine-ip")
    public String examineIp;
    @ConfigProperty(value="%lang%:examine-gamemode")
    public String examineGamemode;
    @ConfigProperty(value="%lang%:examine-location")
    public String examineLocation;
    @ConfigProperty(value="%lang%:examine-warn")
    public String examineWarn;
    @ConfigProperty(value="%lang%:examine-freeze")
    public String examineFreeze;
    @ConfigProperty(value="%lang%:examine-notes")
    public String examineNotes;
    @ConfigProperty(value="%lang%:follow")
    public String follow;
    @ConfigProperty(value="%lang%:strip")
    public String strip;
    @ConfigProperty(value="%lang%:note-added")
    public String noteAdded;
    @ConfigProperty(value="%lang%:note-cleared")
    public String noteCleared;
    @ConfigProperty(value="%lang%:note-deleted")
    public String noteDeleted;
    @ConfigProperty(value="%lang%:notes.staff-notification-created")
    public String noteCreatedNotification;
    @ConfigProperty(value="%lang%:notes.prefix")
    public String prefixPlayerNotes;
    @ConfigProperty(value="%lang%:note-list-start")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> noteListStart;
    @ConfigProperty(value="%lang%:note-list-entry")
    public String noteListEntry;
    @ConfigProperty(value="%lang%:note-list-entry-private")
    public String noteListEntryPrivate;
    @ConfigProperty(value="%lang%:note-list-end")
    @ConfigTransformer(value={MessageMultiLineTransformer.class})
    public List<String> noteListEnd;
    @ConfigProperty(value="%lang%:bypassed")
    public String bypassed;
    @ConfigProperty(value="%lang%:staff-chat-status")
    public String staffChatStatus;
    @ConfigProperty(value="%lang%:staff-chat-muted")
    public String staffChatMuted;
    @ConfigProperty(value="%lang%:staff-chat-unmuted")
    public String staffChatUnmuted;
    @ConfigProperty(value="%lang%:staff-chat-sound-disabled")
    public String staffChatSoundDisabled;
    @ConfigProperty(value="%lang%:staff-chat-sound-enabled")
    public String staffChatSoundEnabled;
    @ConfigProperty(value="%lang%:kick-notifyplayers")
    public String kickedNotify;
    @ConfigProperty(value="%lang%:kick-kickmessage")
    public String kickMessage;
    @ConfigProperty(value="%lang%:ban-unbanned")
    public String unbanned;
    @ConfigProperty(value="%lang%:ban-extended")
    public String banExtended;
    @ConfigProperty(value="%lang%:ban-reduced")
    public String banReduced;
    @ConfigProperty(value="%lang%:ban-permabanned")
    public String permanentBanned;
    @ConfigProperty(value="%lang%:ban-tempbanned")
    public String tempBanned;
    @ConfigProperty(value="%lang%:ban-permabanned-kick")
    public String permanentBannedKick;
    @ConfigProperty(value="%lang%:ban-tempbanned-kick")
    public String tempBannedKick;
    @ConfigProperty(value="%lang%:ipbans.prefix")
    public String prefixBans;
    @ConfigProperty(value="%lang%:ipbans.permabanned")
    public String ipbanPermabanned;
    @ConfigProperty(value="%lang%:ipbans.tempbanned")
    public String ipbanTempbanned;
    @ConfigProperty(value="%lang%:ipbans.unbanned")
    public String ipbanUnbanned;
    @ConfigProperty(value="%lang%:ipbans.tempbanned-kick")
    public String ipbanTempbannedKick;
    @ConfigProperty(value="%lang%:ipbans.permabanned-kick")
    public String ipbanPermabannedKick;
    @ConfigProperty(value="%lang%:ban-appeal-open-notify")
    public String banOpenAppealsNotify;
    @ConfigProperty(value="%lang%:mute-appeal-open-notify")
    public String muteOpenAppealsNotify;
    @ConfigProperty(value="%lang%:mute-expired")
    public String muteExpired;
    @ConfigProperty(value="%lang%:mute-unmuted")
    public String unmuted;
    @ConfigProperty(value="%lang%:mute-permamuted")
    public String permanentMuted;
    @ConfigProperty(value="%lang%:mute-tempmuted")
    public String tempMuted;
    @ConfigProperty(value="%lang%:mute-muted")
    public String muted;
    @ConfigProperty(value="%lang%:mute-extended")
    public String muteExtended;
    @ConfigProperty(value="%lang%:mute-reduced")
    public String muteReduced;
    @ConfigProperty(value="%lang%:appeal-created")
    public String appealCreated;
    @ConfigProperty(value="%lang%:appeal-approved")
    public String appealApproved;
    @ConfigProperty(value="%lang%:appeal-approve")
    public String appealApprove;
    @ConfigProperty(value="%lang%:appeal-rejected")
    public String appealRejected;
    @ConfigProperty(value="%lang%:appeal-reject")
    public String appealReject;
    @ConfigProperty(value="%lang%:appeal-open-notify")
    public String warningOpenAppealsNotify;
    @ConfigProperty(value="%lang%:investigated.investigation-started")
    public String investigatedInvestigationStarted;
    @ConfigProperty(value="%lang%:investigated.investigation-paused")
    public String investigatedInvestigationPaused;
    @ConfigProperty(value="%lang%:investigated.investigation-concluded")
    public String investigatedInvestigationConcluded;
    @ConfigProperty(value="%lang%:investigated.under-investigation-title")
    public String underInvestigationTitle;
    @ConfigProperty(value="%lang%:investigated.under-investigation-join")
    public String underInvestigationJoin;
    @ConfigProperty(value="%lang%:investigation.staff-notification-started")
    public String investigationStaffNotificationsStarted;
    @ConfigProperty(value="%lang%:investigation.staff-notification-concluded")
    public String investigationStaffNotificationsConcluded;
    @ConfigProperty(value="%lang%:investigation.staff-notification-paused")
    public String investigationStaffNotificationsPaused;
    @ConfigProperty(value="%lang%:investigation.staff-notification-evidence-linked")
    public String investigationEvidenceLinked;
    @ConfigProperty(value="%lang%:investigation.staff-notification-evidence-unlinked")
    public String investigationEvidenceUnlinked;
    @ConfigProperty(value="%lang%:investigation.staff-notification-note-added")
    public String investigationNoteAdded;
    @ConfigProperty(value="%lang%:investigation.staff-notification-note-deleted")
    public String investigationNoteDeleted;
    @ConfigProperty(value="%lang%:ips.prefix")
    public String ipsPrefix;
    @ConfigProperty(value="%lang%:ips.issuer.history-cleared")
    public String ipsHistoryCleared;
    @ConfigProperty(value="%lang%:ips.staff-notifications.history-cleared")
    public String ipsHistoryClearedNotification;
    private final PermissionHandler permission;
    private final PlaceholderService placeholderService;

    public Messages(JsonSenderService jsonSenderService, MessageSenderFactory messageSenderFactory, PermissionHandler permission, PlaceholderService placeholderService) {
        this.jsonSenderService = jsonSenderService;
        this.messageSenderFactory = messageSenderFactory;
        this.permission = permission;
        this.placeholderService = placeholderService;
    }

    public String colorize(String message) {
        message = GradientColorProcessor.process(message);
        message = this.processHexColor(message);
        message = message.replace("&&", "<ampersand>");
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message.replace("<ampersand>", "&");
    }

    @NotNull
    private String processHexColor(String message) {
        Matcher matcher = this.hexColorPattern.matcher(message);
        while (matcher.find()) {
            String color = message.substring(matcher.start(), matcher.end());
            message = message.replace(color, net.md_5.bungee.api.ChatColor.of((String)color) + "");
            matcher = this.hexColorPattern.matcher(message);
        }
        return message;
    }

    public String parse(Player player, String message) {
        return this.colorize(this.placeholderService.setPlaceholders(player, message));
    }

    public void send(SppInteractor sppInteractor, String message, String prefix) {
        sppInteractor.getCommandSender().ifPresent(s -> this.send((CommandSender)s, message, prefix));
    }

    public void send(List<Player> receivers, String message, String prefix) {
        receivers.forEach(receiver -> this.send((CommandSender)receiver, message, prefix));
    }

    public void send(Player player, String message, String prefix, String permission) {
        if (!this.permission.has(player, permission)) {
            return;
        }
        this.send((CommandSender)player, message, prefix);
    }

    public void send(CommandSender sender, List<String> messageLines, String prefix) {
        messageLines.forEach(message -> this.send(sender, (String)message, prefix));
    }

    public void sendGlobalMessage(String message, String prefix) {
        Bukkit.getOnlinePlayers().forEach(onlinePlayer -> this.send((CommandSender)onlinePlayer, message, prefix));
    }

    public void sendGroupMessage(String message, String permission, String prefix) {
        if (message == null) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> this.send((Player)player, message, prefix, permission));
    }

    public void sendGroupMessage(JSONMessage jsonMessage, String permission) {
        Bukkit.getOnlinePlayers().stream().filter(p -> this.permission.has((Player)p, permission)).forEach(p -> this.jsonSenderService.send(jsonMessage, (Player)p));
    }

    public void send(CommandSender receiver, String message, String prefix) {
        if (message.startsWith(NO_PREFIX)) {
            prefix = "";
            message = message.replace(NO_PREFIX, "");
        }
        message = this.placeholderService.setPlaceholders(receiver, message);
        prefix = this.placeholderService.setPlaceholders(receiver, prefix);
        this.messageSenderFactory.getSender(receiver, message).sendMessage(receiver, message, prefix);
    }
}

