/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application.config.messages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shortninja.staffplus.core.application.config.messages.MessageSender;
import net.shortninja.staffplus.core.common.gui.gradient.GradientColorProcessor;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMessageSender
implements MessageSender {
    private final Pattern hexColorPattern = Pattern.compile("#[a-fA-F0-9]{6}");

    protected String colorize(String message) {
        message = GradientColorProcessor.process(message);
        message = this.processHexColor(message);
        message = message.replace("&&", "<ampersand>");
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message.replace("<ampersand>", "&");
    }

    @NotNull
    private String processHexColor(String message) {
        Matcher matcher = this.hexColorPattern.matcher(message);
        while (matcher.find()) {
            String color = message.substring(matcher.start(), matcher.end());
            message = message.replace(color, net.md_5.bungee.api.ChatColor.of((String)color) + "");
            matcher = this.hexColorPattern.matcher(message);
        }
        return message;
    }
}

