/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application;

import java.util.Optional;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.bootstrap.LuckPermsHook;
import net.shortninja.staffplus.core.application.bootstrap.VaultHook;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.AfterIocLoad;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBeanProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingConfiguration;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.DatabaseType;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.SqlConnectionProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcsqlmigrations.helpers.QueryBuilderFactory;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.DefaultPermissionHandler;
import net.shortninja.staffplus.core.common.permissions.GroupManagerPermissionHandler;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@TubingConfiguration
public class StaffPlusPlusConfiguration {
    @AfterIocLoad
    public static void initGuiExceptionHandler(GuiActionService guiActionService) {
        guiActionService.registerExceptionHandler(BusinessException.class, (player, e) -> player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)e.getMessage())));
    }

    @IocBeanProvider
    public static PermissionHandler instantiatePermissionHandler(Options options, VaultHook vaultHook) {
        PluginManager pluginManager = StaffPlusPlus.get().getServer().getPluginManager();
        Plugin gMplugin = pluginManager.getPlugin("GroupManager");
        if (gMplugin != null && gMplugin.isEnabled()) {
            StaffPlusPlus.get().getLogger().info("GroupManager found. Permissions will be handled by GroupManager");
            return new GroupManagerPermissionHandler(options);
        }
        try {
            Class.forName("net.milkbowl.vault.permission.Permission", false, StaffPlusPlusConfiguration.class.getClassLoader());
            Optional<PermissionHandler> vaultPermissionHandler = vaultHook.getVaultPermissionHandler();
            if (vaultPermissionHandler.isPresent()) {
                return vaultPermissionHandler.get();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        StaffPlusPlus.get().getLogger().info("Permissions handled by Bukkit");
        return new DefaultPermissionHandler();
    }

    @IocBeanProvider
    public static LuckPermsHook instantiateLuckperms(OnlineSessionsManager sessionManager) {
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            return new LuckPermsHook(sessionManager);
        }
        StaffPlusPlus.get().getLogger().info("Luckperms not found. Not Setting luckperms hook");
        return null;
    }

    @IocBeanProvider
    public static QueryBuilderFactory queryBuilderFactory(@ConfigProperty(value="storage.type") String storageType, SqlConnectionProvider sqlConnectionProvider) {
        if (storageType.equalsIgnoreCase("mysql")) {
            StaffPlusPlus.get().getLogger().info("Using MYSQL storage");
            return new QueryBuilderFactory(DatabaseType.MYSQL, sqlConnectionProvider);
        }
        StaffPlusPlus.get().getLogger().info("Using SQLITE storage");
        return new QueryBuilderFactory(DatabaseType.SQLITE, sqlConnectionProvider);
    }
}

