/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.application;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.SplitByComma;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.cmd.BaseCmd;
import net.shortninja.staffplus.core.common.cmd.CmdHandler;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceService;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@IocBukkitListener
public class PlayerCommandPreprocess
implements Listener {
    @ConfigProperty(value="blocked-commands")
    @ConfigTransformer(value={SplitByComma.class})
    private List<String> blockedCommands = new ArrayList<String>();
    @ConfigProperty(value="blocked-mode-commands")
    @ConfigTransformer(value={SplitByComma.class})
    private List<String> blockedModeCommands = new ArrayList<String>();
    private final PermissionHandler permission;
    private final Options options;
    private final Messages messages;
    private final CmdHandler cmdHandler;
    private final TraceService traceService;
    private final OnlineSessionsManager sessionManager;
    @ConfigProperty(value="permissions:block")
    private String permissionBlock;

    public PlayerCommandPreprocess(PermissionHandler permission, Options options, Messages messages, CmdHandler cmdHandler, TraceService traceService, OnlineSessionsManager sessionManager) {
        this.permission = permission;
        this.options = options;
        this.messages = messages;
        this.cmdHandler = cmdHandler;
        this.traceService = traceService;
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String command = event.getMessage().toLowerCase();
        this.traceService.sendTraceMessage(TraceType.COMMANDS, uuid, "Player invoked command: [" + command + "]");
        if (command.startsWith("/help staffplusplus") || command.startsWith("/help staff++")) {
            this.sendHelp(player);
            event.setCancelled(true);
            return;
        }
        PlayerSession session = this.sessionManager.get(player);
        if (this.blockedCommands.contains(command) && this.permission.hasOnly(player, this.permissionBlock)) {
            this.messages.send((CommandSender)player, this.messages.commandBlocked, this.messages.prefixGeneral);
            event.setCancelled(true);
        } else if (session.isInStaffMode() && this.blockedModeCommands.contains(command)) {
            this.messages.send((CommandSender)player, this.messages.modeCommandBlocked, this.messages.prefixGeneral);
            event.setCancelled(true);
        }
    }

    private void sendHelp(Player player) {
        int count = 0;
        this.messages.send((CommandSender)player, "&7" + this.messages.LONG_LINE, "");
        List sortedCommands = this.cmdHandler.commands.stream().sorted(Comparator.comparing(o -> o.getCommand().getName())).collect(Collectors.toList());
        block0: for (BaseCmd baseCmd : sortedCommands) {
            if (baseCmd.getPermissions().isEmpty()) {
                this.messages.send((CommandSender)player, "&b/" + baseCmd.getCommand().getName() + " &7: " + baseCmd.getDescription().toLowerCase(), "");
                ++count;
                continue;
            }
            for (String permission : baseCmd.getPermissions()) {
                if (!this.permission.has(player, permission)) continue;
                this.messages.send((CommandSender)player, "&b/" + baseCmd.getCommand().getName() + " &7: " + baseCmd.getDescription().toLowerCase(), "");
                ++count;
                continue block0;
            }
        }
        if (count == 0) {
            this.messages.send((CommandSender)player, this.messages.noPermission, this.messages.prefixGeneral);
        }
        this.messages.send((CommandSender)player, "&7" + this.messages.LONG_LINE, "");
    }
}

