/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.handler.GadgetHandler;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@IocBean(conditionalOnProperty="freeze-module.enabled=true")
public class Tasks
extends BukkitRunnable {
    @ConfigProperty(value="permissions:member")
    private String permissionMember;
    @ConfigProperty(value="clock")
    private long clock;
    private final PermissionHandler permission;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final GadgetHandler gadgetHandler;
    private final FreezeConfiguration freezeConfiguration;
    private int freezeInterval;
    private long now;

    public Tasks(PermissionHandler permission, Messages messages, OnlineSessionsManager sessionManager, GadgetHandler gadgetHandler, FreezeConfiguration freezeConfiguration) {
        this.permission = permission;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.gadgetHandler = gadgetHandler;
        this.freezeConfiguration = freezeConfiguration;
        this.freezeInterval = 0;
        this.now = System.currentTimeMillis();
        this.runTaskTimerAsynchronously((Plugin)StaffPlusPlus.get(), this.clock * 20L, this.clock * 20L);
    }

    public void run() {
        this.decideAutosave();
        this.gadgetHandler.updateGadgets();
    }

    private void decideAutosave() {
        long later = System.currentTimeMillis();
        if (later - this.now >= 1000L) {
            int addition = (int)((later - this.now) / 1000L);
            this.freezeInterval += addition;
            this.now = System.currentTimeMillis();
        }
        if (this.freezeInterval >= this.freezeConfiguration.timer && this.freezeInterval > 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerSession session = this.sessionManager.get(player);
                if (!session.isFrozen() || this.permission.has(player, this.permissionMember)) continue;
                if (this.freezeConfiguration.sound != null) {
                    this.freezeConfiguration.sound.play(player);
                }
                if (!this.freezeConfiguration.chatMessageEnabled) continue;
                this.messages.send((CommandSender)player, this.messages.freeze, this.messages.prefixGeneral);
            }
            this.freezeInterval = 0;
        }
    }
}

