/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.bootstrap.PluginDisable;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.TubingBukkitPlugin;
import net.shortninja.staffplusplus.IStaffPlus;
import net.shortninja.staffplusplus.ban.BanService;
import net.shortninja.staffplusplus.mute.MuteService;
import net.shortninja.staffplusplus.reports.ReportService;
import net.shortninja.staffplusplus.session.SessionManager;
import net.shortninja.staffplusplus.staffmode.chat.StaffChatService;
import net.shortninja.staffplusplus.warnings.WarningService;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class StaffPlusPlus
extends TubingBukkitPlugin
implements IStaffPlus {
    private static StaffPlusPlus plugin;

    public static StaffPlusPlus get() {
        return plugin;
    }

    @Override
    protected void beforeEnable() {
        try {
            plugin = this;
            File firstInstallFile = new File(StaffPlusPlus.get().getDataFolder(), "installed.txt");
            if (!firstInstallFile.exists()) {
                this.getLogger().info("First installation detected");
                File oldStaffPlusFolder = new File(this.getDataFolder().getParentFile(), "StaffPlus");
                File newStaffPlusPlusFolder = new File(this.getDataFolder().getParentFile(), "StaffPlusPlus");
                if (oldStaffPlusFolder.exists()) {
                    this.getLogger().info("Copying old staff+ folder");
                    StaffPlusPlus.copyFolder(oldStaffPlusFolder.toPath(), newStaffPlusPlusFolder.toPath());
                }
                firstInstallFile.getParentFile().mkdirs();
                firstInstallFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> StaffPlusPlus.copy(source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void enable() {
        try {
            Bukkit.getServicesManager().register(IStaffPlus.class, (Object)this, (Plugin)this, ServicePriority.Normal);
            this.getLogger().info("Staff++ has been enabled!");
            this.getLogger().info("Plugin created by Shortninja continued by Qball - Revisited by Garagepoort");
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to load plugin: " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    protected void disable() {
        this.getLogger().info("Staff++ is now disabling!");
        if (this.getIocContainer() != null && this.getIocContainer().getList(PluginDisable.class) != null) {
            this.getIocContainer().getList(PluginDisable.class).forEach(b -> b.disable(this));
        }
        this.getLogger().info("Staff++ disabled!");
    }

    @Override
    public StaffChatService getStaffChatService() {
        return StaffPlusPlus.get().getIocContainer().get(StaffChatService.class);
    }

    @Override
    public SessionManager getSessionManager() {
        return StaffPlusPlus.get().getIocContainer().get(SessionManager.class);
    }

    @Override
    public BanService getBanService() {
        return StaffPlusPlus.get().getIocContainer().get(BanService.class);
    }

    @Override
    public MuteService getMuteService() {
        return StaffPlusPlus.get().getIocContainer().get(MuteService.class);
    }

    @Override
    public ReportService getReportService() {
        return StaffPlusPlus.get().getIocContainer().get(ReportService.class);
    }

    @Override
    public WarningService getWarningService() {
        return StaffPlusPlus.get().getIocContainer().get(WarningService.class);
    }
}

