/*
 * Decompiled with CFR 0.152.
 */
package be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import net.shortninja.staffplus.libs.com.google.gson.JsonArray;
import net.shortninja.staffplus.libs.com.google.gson.JsonElement;
import net.shortninja.staffplus.libs.com.google.gson.JsonObject;
import net.shortninja.staffplus.libs.com.google.gson.JsonPrimitive;
import org.bukkit.ChatColor;

public class JSONMessage {
    private static final BiMap<ChatColor, String> stylesToNames;
    private final List<MessagePart> parts = new ArrayList<MessagePart>();
    private int centeringStartIndex = -1;

    private JSONMessage(String text) {
        this.parts.add(new MessagePart(text));
    }

    public static JSONMessage create(String text) {
        return new JSONMessage(text);
    }

    public static JSONMessage create() {
        return JSONMessage.create("");
    }

    public MessagePart last() {
        if (this.parts.size() <= 0) {
            throw new ArrayIndexOutOfBoundsException("No MessageParts exist!");
        }
        return this.parts.get(this.parts.size() - 1);
    }

    public JsonObject toJSON() {
        JsonObject obj = new JsonObject();
        obj.addProperty("text", "");
        JsonArray array = new JsonArray();
        this.parts.stream().map(MessagePart::toJSON).forEach(array::add);
        obj.add("extra", array);
        return obj;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public String toLegacy() {
        StringBuilder output = new StringBuilder();
        this.parts.stream().map(MessagePart::toLegacy).forEach(output::append);
        return output.toString();
    }

    public JSONMessage color(ChatColor color) {
        if (!color.isColor()) {
            throw new IllegalArgumentException(color.name() + " is not a color.");
        }
        this.last().setColor(color);
        return this;
    }

    public JSONMessage color(String color) {
        return this.color(color, ChatColor.WHITE);
    }

    public JSONMessage color(String color, ChatColor def) {
        this.last().setColor(color);
        return this;
    }

    public JSONMessage font(String font) {
        this.last().setFont(font);
        return this;
    }

    public JSONMessage style(ChatColor style) {
        this.last().addStyle(style);
        return this;
    }

    public JSONMessage runCommand(String command) {
        this.last().setOnClick(ClickEvent.runCommand(command));
        return this;
    }

    public JSONMessage suggestCommand(String command) {
        this.last().setOnClick(ClickEvent.suggestCommand(command));
        return this;
    }

    public JSONMessage openURL(String url) {
        this.last().setOnClick(ClickEvent.openURL(url));
        return this;
    }

    public JSONMessage copyText(String text) {
        this.last().setOnClick(ClickEvent.copyText(text));
        return this;
    }

    public JSONMessage changePage(int page) {
        this.last().setOnClick(ClickEvent.changePage(page));
        return this;
    }

    public JSONMessage tooltip(String text) {
        this.last().setOnHover(HoverEvent.showText(text));
        return this;
    }

    public JSONMessage tooltip(JSONMessage message) {
        this.last().setOnHover(HoverEvent.showText(message));
        return this;
    }

    public JSONMessage achievement(String id) {
        this.last().setOnHover(HoverEvent.showAchievement(id));
        return this;
    }

    public JSONMessage then(String text) {
        return this.then(new MessagePart(text));
    }

    public JSONMessage then(MessagePart nextPart) {
        this.parts.add(nextPart);
        return this;
    }

    public JSONMessage bar(int length) {
        return this.then(Strings.repeat((String)"-", (int)length)).color(ChatColor.DARK_GRAY).style(ChatColor.STRIKETHROUGH);
    }

    public JSONMessage bar() {
        return this.bar(53);
    }

    public JSONMessage newline() {
        return this.then("\n");
    }

    public JSONMessage beginCenter() {
        this.centeringStartIndex = this.parts.size();
        return this;
    }

    public JSONMessage endCenter() {
        int current = this.centeringStartIndex;
        block0: while (current < this.parts.size()) {
            Vector<MessagePart> currentLine = new Vector<MessagePart>();
            int totalLineLength = 0;
            while (true) {
                int rawLength;
                MessagePart part = current < this.parts.size() ? this.parts.get(current) : null;
                String raw = part == null ? null : ChatColor.stripColor((String)part.toLegacy());
                int n = rawLength = raw == null ? 0 : raw.length();
                if (current >= this.parts.size() || totalLineLength + rawLength >= 53) {
                    int padding = Math.max(0, (53 - totalLineLength) / 2);
                    ((MessagePart)currentLine.firstElement()).setText(Strings.repeat((String)" ", (int)padding) + ((MessagePart)currentLine.firstElement()).getText());
                    ((MessagePart)currentLine.lastElement()).setText(((MessagePart)currentLine.lastElement()).getText() + "\n");
                    currentLine.clear();
                    continue block0;
                }
                totalLineLength += rawLength;
                currentLine.add(part);
                ++current;
            }
        }
        MessagePart last = this.parts.get(this.parts.size() - 1);
        last.setText(last.getText().substring(0, last.getText().length() - 1));
        this.centeringStartIndex = -1;
        return this;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ChatColor style : ChatColor.values()) {
            if (!style.isFormat()) continue;
            builder.put((Object)style, (Object)(switch (style) {
                case ChatColor.MAGIC -> "obfuscated";
                case ChatColor.UNDERLINE -> "underlined";
                default -> style.name().toLowerCase();
            }));
        }
        stylesToNames = builder.build();
    }

    public static class MessagePart {
        private final List<ChatColor> styles = new ArrayList<ChatColor>();
        private MessageEvent onClick;
        private MessageEvent onHover;
        private String color;
        private ChatColor legacyColor;
        private String font;
        private String text;

        public MessagePart(String text) {
            this.text = text == null ? "null" : text;
        }

        public JsonObject toJSON() {
            Objects.requireNonNull(this.text);
            JsonObject obj = new JsonObject();
            obj.addProperty("text", this.text);
            if (this.color != null && !this.color.isEmpty()) {
                obj.addProperty("color", this.color.toLowerCase());
            }
            for (ChatColor style : this.styles) {
                obj.addProperty((String)stylesToNames.get((Object)style), true);
            }
            if (this.onClick != null) {
                obj.add("clickEvent", this.onClick.toJSON());
            }
            if (this.onHover != null) {
                obj.add("hoverEvent", this.onHover.toJSON());
            }
            if (this.font != null) {
                obj.addProperty("font", this.font);
            }
            return obj;
        }

        public String toLegacy() {
            StringBuilder output = new StringBuilder();
            ChatColor legacyColor = this.getColor();
            if (legacyColor != null) {
                output.append(legacyColor);
            }
            this.styles.stream().map(ChatColor::toString).forEach(output::append);
            return output.append(this.text).toString();
        }

        public MessageEvent getOnClick() {
            return this.onClick;
        }

        public void setOnClick(MessageEvent onClick) {
            this.onClick = onClick;
        }

        public MessageEvent getOnHover() {
            return this.onHover;
        }

        public void setOnHover(MessageEvent onHover) {
            this.onHover = onHover;
        }

        public String getColorValue() {
            return this.color;
        }

        @Deprecated
        public ChatColor getColor() {
            if (this.legacyColor != null) {
                return this.legacyColor;
            }
            try {
                return ChatColor.valueOf((String)this.color.toUpperCase());
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Deprecated
        public void setColor(ChatColor color) {
            this.setColor(color == null ? null : color.name().toLowerCase());
            this.setLegacyColor(color);
        }

        @Deprecated
        public void setLegacyColor(ChatColor color) {
            this.legacyColor = color;
        }

        public void setColor(String color) {
            if (color != null && color.isEmpty()) {
                throw new IllegalArgumentException("Color cannot be null!");
            }
            this.color = color;
        }

        public List<ChatColor> getStyles() {
            return this.styles;
        }

        public void addStyle(ChatColor style) {
            if (style == null) {
                throw new IllegalArgumentException("Style cannot be null!");
            }
            if (!style.isFormat()) {
                throw new IllegalArgumentException(style.name() + " is not a style!");
            }
            this.styles.add(style);
        }

        public String getFont() {
            return this.font;
        }

        public void setFont(String font) {
            this.font = font;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public static class ClickEvent {
        public static MessageEvent runCommand(String command) {
            return new MessageEvent("run_command", command);
        }

        public static MessageEvent suggestCommand(String command) {
            return new MessageEvent("suggest_command", command);
        }

        public static MessageEvent openURL(String url) {
            return new MessageEvent("open_url", url);
        }

        public static MessageEvent changePage(int page) {
            return new MessageEvent("change_page", page);
        }

        public static MessageEvent copyText(String text) {
            return new MessageEvent("copy_to_clipboard", text);
        }
    }

    public static class MessageEvent {
        private String action;
        private Object value;

        public MessageEvent(String action, Object value) {
            this.action = action;
            this.value = value;
        }

        public JsonObject toJSON() {
            String valueType;
            JsonObject obj = new JsonObject();
            obj.addProperty("action", this.action);
            String string = valueType = this.action.startsWith("show_") ? "contents" : "value";
            if (this.value instanceof JsonElement) {
                obj.add(valueType, (JsonElement)this.value);
            } else {
                obj.addProperty(valueType, this.value.toString());
            }
            return obj;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class HoverEvent {
        public static MessageEvent showText(String text) {
            return new MessageEvent("show_text", text);
        }

        public static MessageEvent showText(JSONMessage message) {
            JsonArray arr = new JsonArray();
            arr.add(new JsonPrimitive(""));
            arr.add(message.toJSON());
            return new MessageEvent("show_text", arr);
        }

        public static MessageEvent showAchievement(String id) {
            return new MessageEvent("show_achievement", id);
        }
    }
}

