/*
 * Decompiled with CFR 0.152.
 */
package be.garagepoort.staffplusplus.craftbukkit.common.json;

import be.garagepoort.staffplusplus.craftbukkit.common.json.JsonMessage;
import net.shortninja.staffplus.libs.org.json.simple.JSONObject;

public class JsonStringBuilder {
    private final JsonMessage message;
    private final String string;
    private String hover = "";
    private String click = "";

    public JsonStringBuilder(JsonMessage msg, String text) {
        this.message = msg;
        this.string = ",{\"text\":\"" + text + "\"";
    }

    private String esc(String s) {
        return JSONObject.escape(s);
    }

    public JsonStringBuilder setHoverAsTooltip(String ... lore) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lore.length; ++i) {
            if (i + 1 == lore.length) {
                builder.append(lore[i]);
                continue;
            }
            builder.append(lore[i] + "\n");
        }
        this.hover = ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":\"" + this.esc(builder.toString()) + "\"}";
        return this;
    }

    public JsonStringBuilder setHoverAsAchievement(String ach) {
        this.hover = ",\"hoverEvent\":{\"action\":\"show_achievement\",\"value\":\"achievement." + this.esc(ach) + "\"}";
        return this;
    }

    public JsonStringBuilder setClickAsURL(String link) {
        this.click = ",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + this.esc(link) + "\"}";
        return this;
    }

    public JsonStringBuilder setClickAsSuggestCmd(String cmd) {
        this.click = ",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + this.esc(cmd) + "\"}";
        return this;
    }

    public JsonStringBuilder setClickAsExecuteCmd(String cmd) {
        this.click = ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + this.esc(cmd) + "\"}";
        return this;
    }

    public JsonMessage save() {
        this.message.msg = this.message.msg + this.string + this.hover + this.click + "}";
        return this.message;
    }
}

