/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.script.functions;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.StructureScript;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.world.WritableWorld;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureFunction
implements Function<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructureFunction.class);
    private final Registry<Structure> registry;
    private final Returnable<String> id;
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;
    private final Platform platform;
    private final List<Returnable<String>> rotations;

    public StructureFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Returnable<String> id, List<Returnable<String>> rotations, Registry<Structure> registry, Position position, Platform platform) {
        this.registry = registry;
        this.id = id;
        this.position = position;
        this.x = x;
        this.y = y;
        this.z = z;
        this.platform = platform;
        this.rotations = rotations;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.BOOLEAN;
    }

    @Override
    public Boolean apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        if (arguments.getRecursions() > this.platform.getTerraConfig().getMaxRecursion()) {
            throw new RuntimeException("Structure recursion too deep: " + arguments.getRecursions());
        }
        Vector2 xz = RotationUtil.rotateVector((Vector2)Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue()), (Rotation)arguments.getRotation());
        String app = (String)this.id.apply(implementationArguments, scope);
        return this.registry.getByID(app).map(script -> {
            Rotation rotation1;
            String rotString = (String)this.rotations.get(arguments.getRandom().nextInt(this.rotations.size())).apply(implementationArguments, scope);
            try {
                rotation1 = Rotation.valueOf((String)rotString);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Invalid rotation {}", (Object)rotString);
                return false;
            }
            if (script instanceof StructureScript) {
                StructureScript structureScript = (StructureScript)script;
                return structureScript.generate(arguments.getOrigin(), (WritableWorld)arguments.getWorld().buffer(FastMath.roundToInt(xz.getX()), ((Number)this.y.apply(implementationArguments, scope)).intValue(), FastMath.roundToInt(xz.getZ())), arguments.getRandom(), arguments.getRotation().rotate(rotation1), arguments.getRecursions() + 1);
            }
            return script.generate(arguments.getOrigin(), (WritableWorld)arguments.getWorld().buffer(FastMath.roundToInt(xz.getX()), ((Number)this.y.apply(implementationArguments, scope)).intValue(), FastMath.roundToInt(xz.getZ())), arguments.getRandom(), arguments.getRotation().rotate(rotation1));
        }).orElseGet(() -> {
            LOGGER.error("No such structure {}", (Object)app);
            return false;
        });
    }

    @Override
    public Position getPosition() {
        return this.position;
    }
}

