/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.script.functions;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.exceptions.ParseException;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.ConstantExpression;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3;

public class PullFunction
implements Function<Void> {
    private final BlockState data;
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;

    public PullFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Returnable<String> data, Platform platform, Position position) {
        this.position = position;
        if (!(data instanceof ConstantExpression)) {
            throw new ParseException("Block data must be constant", data.getPosition());
        }
        this.data = platform.getWorldHandle().createBlockState((String)((ConstantExpression)data).getConstant());
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Void apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = RotationUtil.rotateVector((Vector2)Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue()), (Rotation)arguments.getRotation());
        Vector3.Mutable mutable = Vector3.of((double)FastMath.roundToInt(xz.getX()), (double)((Number)this.y.apply(implementationArguments, scope)).intValue(), (double)FastMath.roundToInt(xz.getZ())).mutable().add(arguments.getOrigin());
        while (mutable.getY() > (double)arguments.getWorld().getMinHeight()) {
            if (!arguments.getWorld().getBlockState((Vector3)mutable).isAir()) {
                arguments.getWorld().setBlockState(mutable, this.data);
                break;
            }
            mutable.subtract(0, 1, 0);
        }
        return null;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.VOID;
    }
}

