/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.script.functions;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.StructureScript;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.block.entity.BlockEntity;
import com.dfsek.terra.api.block.entity.Container;
import com.dfsek.terra.api.event.events.Event;
import com.dfsek.terra.api.event.events.world.generation.LootPopulateEvent;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.api.registry.key.RegistryKey;
import com.dfsek.terra.api.structure.LootTable;
import com.dfsek.terra.api.structure.Structure;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LootFunction
implements Function<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LootFunction.class);
    private final Registry<LootTable> registry;
    private final Returnable<String> data;
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;
    private final Platform platform;
    private final StructureScript script;

    public LootFunction(Registry<LootTable> registry, Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Returnable<String> data, Platform platform, Position position, StructureScript script) {
        this.registry = registry;
        this.position = position;
        this.data = data;
        this.x = x;
        this.y = y;
        this.z = z;
        this.platform = platform;
        this.script = script;
    }

    @Override
    public Void apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = RotationUtil.rotateVector((Vector2)Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue()), (Rotation)arguments.getRotation());
        String id = (String)this.data.apply(implementationArguments, scope);
        this.registry.get(RegistryKey.parse((String)id)).ifPresentOrElse(table -> {
            Vector3 apply = Vector3.of((double)FastMath.roundToInt(xz.getX()), (double)((Number)this.y.apply(implementationArguments, scope)).intValue(), (double)FastMath.roundToInt(xz.getZ())).mutable().add(arguments.getOrigin()).immutable();
            try {
                BlockEntity data = arguments.getWorld().getBlockEntity(apply);
                if (!(data instanceof Container)) {
                    LOGGER.error("Failed to place loot at {}; block {} is not a container", (Object)apply, (Object)data);
                    return;
                }
                Container container = (Container)data;
                LootPopulateEvent event = new LootPopulateEvent(container, table, arguments.getWorld().getPack(), (Structure)this.script);
                this.platform.getEventManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                event.getTable().fillInventory(container.getInventory(), new Random(apply.hashCode()));
                data.update(false);
            }
            catch (Exception e) {
                LOGGER.error("Could not apply loot at {}", (Object)apply, (Object)e);
                e.printStackTrace();
            }
        }, () -> LOGGER.error("No such loot table {}", (Object)id));
        return null;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.VOID;
    }
}

