/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.script.functions;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.StringConstant;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.handle.WorldHandle;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockFunction
implements Function<Void> {
    private static final Logger logger = LoggerFactory.getLogger(BlockFunction.class);
    protected final Returnable<Number> x;
    protected final Returnable<Number> y;
    protected final Returnable<Number> z;
    protected final Returnable<String> blockData;
    protected final Platform platform;
    private final Map<String, BlockState> data = new HashMap<String, BlockState>();
    private final Returnable<Boolean> overwrite;
    private final Position position;

    public BlockFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Returnable<String> blockData, Returnable<Boolean> overwrite, Platform platform, Position position) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockData = blockData;
        this.overwrite = overwrite;
        this.platform = platform;
        this.position = position;
    }

    @Override
    public Void apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        BlockState rot = this.getBlockState(implementationArguments, scope);
        this.setBlock(implementationArguments, scope, arguments, rot);
        return null;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.VOID;
    }

    void setBlock(ImplementationArguments implementationArguments, Scope scope, TerraImplementationArguments arguments, BlockState rot) {
        Vector2 xz = RotationUtil.rotateVector((Vector2)Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue()), (Rotation)arguments.getRotation());
        try {
            Vector3.Mutable set = Vector3.of((double)FastMath.roundToInt(xz.getX()), (double)((Number)this.y.apply(implementationArguments, scope)).doubleValue(), (double)FastMath.roundToInt(xz.getZ())).mutable().add(arguments.getOrigin());
            BlockState current = arguments.getWorld().getBlockState((Vector3)set);
            if (((Boolean)this.overwrite.apply(implementationArguments, scope)).booleanValue() || current.isAir()) {
                arguments.getWorld().setBlockState(set, rot);
            }
        }
        catch (RuntimeException e) {
            logger.error("Failed to place block at location {}", (Object)arguments.getOrigin(), (Object)e);
        }
    }

    protected BlockState getBlockState(ImplementationArguments arguments, Scope scope) {
        return this.data.computeIfAbsent((String)this.blockData.apply(arguments, scope), arg_0 -> ((WorldHandle)this.platform.getWorldHandle()).createBlockState(arg_0));
    }

    public static class Constant
    extends BlockFunction {
        private final BlockState state;

        public Constant(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, StringConstant blockData, Returnable<Boolean> overwrite, Platform platform, Position position) {
            super(x, y, z, blockData, overwrite, platform, position);
            this.state = platform.getWorldHandle().createBlockState((String)blockData.getConstant());
        }

        @Override
        protected BlockState getBlockState(ImplementationArguments arguments, Scope scope) {
            return this.state;
        }
    }
}

