/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.script.functions;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.script.TerraImplementationArguments;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.RotationUtil;
import com.dfsek.terra.api.util.vector.Vector2;
import com.dfsek.terra.api.util.vector.Vector3;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;

public class BiomeFunction
implements Function<String> {
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;

    public BiomeFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Position position) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = position;
    }

    @Override
    public String apply(ImplementationArguments implementationArguments, Scope scope) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = RotationUtil.rotateVector((Vector2)Vector2.of((double)((Number)this.x.apply(implementationArguments, scope)).doubleValue(), (double)((Number)this.z.apply(implementationArguments, scope)).doubleValue()), (Rotation)arguments.getRotation());
        BiomeProvider grid = arguments.getWorld().getBiomeProvider();
        return grid.getBiome(arguments.getOrigin().toVector3().mutable().add(Vector3.of((double)FastMath.roundToInt(xz.getX()), (double)((Number)this.y.apply(implementationArguments, scope)).intValue(), (double)FastMath.roundToInt(xz.getZ()))).immutable(), arguments.getWorld().getSeed()).getID();
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.STRING;
    }
}

