/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.parser.lang;

import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Item;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import java.util.List;

public class Block
implements Item<ReturnInfo<?>> {
    private final List<Item<?>> items;
    private final Position position;

    public Block(List<Item<?>> items, Position position) {
        this.items = items;
        this.position = position;
    }

    @Override
    public ReturnInfo<?> apply(ImplementationArguments implementationArguments, Scope scope) {
        for (Item<?> item : this.items) {
            ReturnInfo level;
            Object result = item.apply(implementationArguments, scope);
            if (!(result instanceof ReturnInfo) || (level = (ReturnInfo)result).getLevel().equals((Object)ReturnLevel.NONE)) continue;
            return level;
        }
        return new ReturnInfo<Object>(ReturnLevel.NONE, null);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public static class ReturnInfo<T> {
        private final ReturnLevel level;
        private final T data;

        public ReturnInfo(ReturnLevel level, T data) {
            this.level = level;
            this.data = data;
        }

        public ReturnLevel getLevel() {
            return this.level;
        }

        public T getData() {
            return this.data;
        }
    }

    public static enum ReturnLevel {
        NONE(false),
        BREAK(false),
        CONTINUE(false),
        RETURN(true),
        FAIL(true);

        private final boolean returnFast;

        private ReturnLevel(boolean returnFast) {
            this.returnFast = returnFast;
        }

        public boolean isReturnFast() {
            return this.returnFast;
        }
    }
}

