/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.parser;

import com.dfsek.terra.addons.terrascript.parser.ParserUtil;
import com.dfsek.terra.addons.terrascript.parser.exceptions.ParseException;
import com.dfsek.terra.addons.terrascript.parser.lang.Block;
import com.dfsek.terra.addons.terrascript.parser.lang.Executable;
import com.dfsek.terra.addons.terrascript.parser.lang.Item;
import com.dfsek.terra.addons.terrascript.parser.lang.Keyword;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.BooleanConstant;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.ConstantExpression;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.NumericConstant;
import com.dfsek.terra.addons.terrascript.parser.lang.constants.StringConstant;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.Function;
import com.dfsek.terra.addons.terrascript.parser.lang.functions.FunctionBuilder;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.flow.BreakKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.flow.ContinueKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.flow.FailKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.flow.ReturnKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.looplike.ForKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.looplike.IfKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.keywords.looplike.WhileKeyword;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.BinaryOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.BooleanAndOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.BooleanNotOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.BooleanOrOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.ConcatenationOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.DivisionOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.ModuloOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.MultiplicationOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.NegationOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.NumberAdditionOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.SubtractionOperation;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.statements.EqualsStatement;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.statements.GreaterOrEqualsThanStatement;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.statements.GreaterThanStatement;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.statements.LessThanOrEqualsStatement;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.statements.LessThanStatement;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.statements.NotEqualsStatement;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.assign.BoolAssignmentNode;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.assign.NumAssignmentNode;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.assign.StrAssignmentNode;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.assign.VariableAssignmentNode;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.reference.BoolVariableReferenceNode;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.reference.NumVariableReferenceNode;
import com.dfsek.terra.addons.terrascript.parser.lang.variables.reference.StrVariableReferenceNode;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;
import com.dfsek.terra.addons.terrascript.tokenizer.Token;
import com.dfsek.terra.addons.terrascript.tokenizer.Tokenizer;
import com.dfsek.terra.api.util.generic.pair.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser {
    private final String data;
    private final Map<String, FunctionBuilder<? extends Function<?>>> functions = new HashMap();
    private final List<String> ignoredFunctions = new ArrayList<String>();

    public Parser(String data) {
        this.data = data;
    }

    public Parser registerFunction(String name, FunctionBuilder<? extends Function<?>> functionBuilder) {
        this.functions.put(name, functionBuilder);
        return this;
    }

    public Parser ignoreFunction(String name) {
        this.ignoredFunctions.add(name);
        return this;
    }

    public Executable parse() {
        Scope.ScopeBuilder scopeBuilder = new Scope.ScopeBuilder();
        return new Executable(this.parseBlock(new Tokenizer(this.data), false, scopeBuilder), scopeBuilder);
    }

    private Keyword<?> parseLoopLike(Tokenizer tokens, boolean loop, Scope.ScopeBuilder scopeBuilder) throws ParseException {
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IF_STATEMENT, Token.Type.WHILE_LOOP, Token.Type.FOR_LOOP);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_BEGIN);
        return switch (identifier.getType()) {
            case Token.Type.FOR_LOOP -> this.parseForLoop(tokens, identifier.getPosition(), scopeBuilder);
            case Token.Type.IF_STATEMENT -> this.parseIfStatement(tokens, identifier.getPosition(), loop, scopeBuilder);
            case Token.Type.WHILE_LOOP -> this.parseWhileLoop(tokens, identifier.getPosition(), scopeBuilder);
            default -> throw new UnsupportedOperationException("Unknown keyword " + identifier.getContent() + ": " + identifier.getPosition());
        };
    }

    private WhileKeyword parseWhileLoop(Tokenizer tokens, Position start, Scope.ScopeBuilder scopeBuilder) {
        Returnable<Boolean> first = this.parseExpression(tokens, true, scopeBuilder);
        ParserUtil.checkReturnType(first, Returnable.ReturnType.BOOLEAN);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        return new WhileKeyword(this.parseStatementBlock(tokens, true, scopeBuilder), first, start);
    }

    private IfKeyword parseIfStatement(Tokenizer tokens, Position start, boolean loop, Scope.ScopeBuilder scopeBuilder) {
        Returnable<Boolean> condition = this.parseExpression(tokens, true, scopeBuilder);
        ParserUtil.checkReturnType(condition, Returnable.ReturnType.BOOLEAN);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        Block elseBlock = null;
        Block statement = this.parseStatementBlock(tokens, loop, scopeBuilder);
        ArrayList<Pair<Returnable<Boolean>, Block>> elseIf = new ArrayList<Pair<Returnable<Boolean>, Block>>();
        while (tokens.hasNext() && tokens.get().getType().equals((Object)Token.Type.ELSE)) {
            tokens.consume();
            if (tokens.get().getType().equals((Object)Token.Type.IF_STATEMENT)) {
                tokens.consume();
                Returnable<?> elseCondition = this.parseExpression(tokens, true, scopeBuilder);
                ParserUtil.checkReturnType(elseCondition, Returnable.ReturnType.BOOLEAN);
                elseIf.add((Pair<Returnable<Boolean>, Block>)Pair.of(elseCondition, (Object)this.parseStatementBlock(tokens, loop, scopeBuilder)));
                continue;
            }
            elseBlock = this.parseStatementBlock(tokens, loop, scopeBuilder);
            break;
        }
        return new IfKeyword(statement, condition, elseIf, elseBlock, start);
    }

    private Block parseStatementBlock(Tokenizer tokens, boolean loop, Scope.ScopeBuilder scopeBuilder) {
        if (tokens.get().getType().equals((Object)Token.Type.BLOCK_BEGIN)) {
            ParserUtil.checkType(tokens.consume(), Token.Type.BLOCK_BEGIN);
            Block block = this.parseBlock(tokens, loop, scopeBuilder);
            ParserUtil.checkType(tokens.consume(), Token.Type.BLOCK_END);
            return block;
        }
        Position position = tokens.get().getPosition();
        Block block = new Block(Collections.singletonList(this.parseItem(tokens, loop, scopeBuilder)), position);
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        return block;
    }

    private ForKeyword parseForLoop(Tokenizer tokens, Position start, Scope.ScopeBuilder scopeBuilder) {
        Item<?> initializer;
        scopeBuilder = scopeBuilder.sub();
        Token f = tokens.get();
        ParserUtil.checkType(f, Token.Type.NUMBER_VARIABLE, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.IDENTIFIER);
        if (f.isVariableDeclaration()) {
            VariableAssignmentNode<?> forVar = this.parseVariableDeclaration(tokens, scopeBuilder);
            Token name = tokens.get();
            if (this.functions.containsKey(name.getContent()) || scopeBuilder.contains(name.getContent())) {
                throw new ParseException(name.getContent() + " is already defined in this scope", name.getPosition());
            }
            initializer = forVar;
        } else {
            initializer = this.parseExpression(tokens, true, scopeBuilder);
        }
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        Returnable<Boolean> conditional = this.parseExpression(tokens, true, scopeBuilder);
        ParserUtil.checkReturnType(conditional, Returnable.ReturnType.BOOLEAN);
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        Token token = tokens.get();
        Item<?> incrementer = scopeBuilder.contains(token.getContent()) ? this.parseAssignment(tokens, scopeBuilder) : this.parseFunction(tokens, true, scopeBuilder);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        return new ForKeyword(this.parseStatementBlock(tokens, true, scopeBuilder), initializer, conditional, incrementer, start);
    }

    private Returnable<?> parseExpression(Tokenizer tokens, boolean full, Scope.ScopeBuilder scopeBuilder) {
        Returnable<Boolean> expression;
        boolean booleanInverted = false;
        boolean negate = false;
        if (tokens.get().getType().equals((Object)Token.Type.BOOLEAN_NOT)) {
            booleanInverted = true;
            tokens.consume();
        } else if (tokens.get().getType().equals((Object)Token.Type.SUBTRACTION_OPERATOR)) {
            negate = true;
            tokens.consume();
        }
        Token id = tokens.get();
        ParserUtil.checkType(id, Token.Type.IDENTIFIER, Token.Type.BOOLEAN, Token.Type.STRING, Token.Type.NUMBER, Token.Type.GROUP_BEGIN);
        if (id.isConstant()) {
            expression = this.parseConstantExpression(tokens);
        } else if (id.getType().equals((Object)Token.Type.GROUP_BEGIN)) {
            expression = this.parseGroup(tokens, scopeBuilder);
        } else if (this.functions.containsKey(id.getContent())) {
            expression = this.parseFunction(tokens, false, scopeBuilder);
        } else if (scopeBuilder.contains(id.getContent())) {
            ParserUtil.checkType(tokens.consume(), Token.Type.IDENTIFIER);
            String varId = id.getContent();
            Returnable.ReturnType varType = scopeBuilder.getType(varId);
            expression = switch (varType) {
                case Returnable.ReturnType.NUMBER -> new NumVariableReferenceNode(id.getPosition(), varType, scopeBuilder.getIndex(varId));
                case Returnable.ReturnType.STRING -> new StrVariableReferenceNode(id.getPosition(), varType, scopeBuilder.getIndex(varId));
                case Returnable.ReturnType.BOOLEAN -> new BoolVariableReferenceNode(id.getPosition(), varType, scopeBuilder.getIndex(varId));
                default -> throw new ParseException("Illegal type for variable reference: " + varType, id.getPosition());
            };
        } else {
            throw new ParseException("Unexpected token \" " + id.getContent() + "\"", id.getPosition());
        }
        if (booleanInverted) {
            ParserUtil.checkReturnType(expression, Returnable.ReturnType.BOOLEAN);
            expression = new BooleanNotOperation(expression, expression.getPosition());
        } else if (negate) {
            ParserUtil.checkReturnType(expression, Returnable.ReturnType.NUMBER);
            expression = new NegationOperation((Returnable<Number>)expression, expression.getPosition());
        }
        if (full && tokens.get().isBinaryOperator()) {
            return this.parseBinaryOperation(expression, tokens, scopeBuilder);
        }
        return expression;
    }

    private ConstantExpression<?> parseConstantExpression(Tokenizer tokens) {
        Token constantToken = tokens.consume();
        Position position = constantToken.getPosition();
        switch (constantToken.getType()) {
            case NUMBER: {
                String content = constantToken.getContent();
                return new NumericConstant(content.contains(".") ? Double.parseDouble(content) : (double)Integer.parseInt(content), position);
            }
            case STRING: {
                return new StringConstant(constantToken.getContent(), position);
            }
            case BOOLEAN: {
                return new BooleanConstant(Boolean.parseBoolean(constantToken.getContent()), position);
            }
        }
        throw new UnsupportedOperationException("Unsupported constant token: " + constantToken.getType() + " at position: " + position);
    }

    private Returnable<?> parseGroup(Tokenizer tokens, Scope.ScopeBuilder scopeBuilder) {
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_BEGIN);
        Returnable<?> expression = this.parseExpression(tokens, true, scopeBuilder);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        return expression;
    }

    private BinaryOperation<?, ?> parseBinaryOperation(Returnable<?> left, Tokenizer tokens, Scope.ScopeBuilder scopeBuilder) {
        Token binaryOperator = tokens.consume();
        ParserUtil.checkBinaryOperator(binaryOperator);
        Returnable<?> right = this.parseExpression(tokens, false, scopeBuilder);
        Token other = tokens.get();
        if (ParserUtil.hasPrecedence(binaryOperator.getType(), other.getType())) {
            return this.assemble(left, this.parseBinaryOperation(right, tokens, scopeBuilder), binaryOperator);
        }
        if (other.isBinaryOperator()) {
            return this.parseBinaryOperation(this.assemble(left, right, binaryOperator), tokens, scopeBuilder);
        }
        return this.assemble(left, right, binaryOperator);
    }

    private BinaryOperation<?, ?> assemble(Returnable<?> left, Returnable<?> right, Token binaryOperator) {
        if (binaryOperator.isStrictNumericOperator()) {
            ParserUtil.checkArithmeticOperation(left, right, binaryOperator);
        }
        if (binaryOperator.isStrictBooleanOperator()) {
            ParserUtil.checkBooleanOperation(left, right, binaryOperator);
        }
        switch (binaryOperator.getType()) {
            case ADDITION_OPERATOR: {
                if (left.returnType().equals((Object)Returnable.ReturnType.NUMBER) && right.returnType().equals((Object)Returnable.ReturnType.NUMBER)) {
                    return new NumberAdditionOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
                }
                return new ConcatenationOperation(left, right, binaryOperator.getPosition());
            }
            case SUBTRACTION_OPERATOR: {
                return new SubtractionOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case MULTIPLICATION_OPERATOR: {
                return new MultiplicationOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case DIVISION_OPERATOR: {
                return new DivisionOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case EQUALS_OPERATOR: {
                return new EqualsStatement(left, right, binaryOperator.getPosition());
            }
            case NOT_EQUALS_OPERATOR: {
                return new NotEqualsStatement(left, right, binaryOperator.getPosition());
            }
            case GREATER_THAN_OPERATOR: {
                return new GreaterThanStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case LESS_THAN_OPERATOR: {
                return new LessThanStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case GREATER_THAN_OR_EQUALS_OPERATOR: {
                return new GreaterOrEqualsThanStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case LESS_THAN_OR_EQUALS_OPERATOR: {
                return new LessThanOrEqualsStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case BOOLEAN_AND: {
                return new BooleanAndOperation((Returnable<Boolean>)left, (Returnable<Boolean>)right, binaryOperator.getPosition());
            }
            case BOOLEAN_OR: {
                return new BooleanOrOperation((Returnable<Boolean>)left, (Returnable<Boolean>)right, binaryOperator.getPosition());
            }
            case MODULO_OPERATOR: {
                return new ModuloOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
        }
        throw new UnsupportedOperationException("Unsupported binary operator: " + binaryOperator.getType());
    }

    private VariableAssignmentNode<?> parseVariableDeclaration(Tokenizer tokens, Scope.ScopeBuilder scopeBuilder) {
        Token type = tokens.consume();
        ParserUtil.checkType(type, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.NUMBER_VARIABLE);
        Returnable.ReturnType returnType = ParserUtil.getVariableReturnType(type);
        ParserUtil.checkVarType(type, returnType);
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IDENTIFIER);
        if (this.functions.containsKey(identifier.getContent()) || scopeBuilder.contains(identifier.getContent())) {
            throw new ParseException(identifier.getContent() + " is already defined in this scope", identifier.getPosition());
        }
        ParserUtil.checkType(tokens.consume(), Token.Type.ASSIGNMENT);
        Returnable<Number> value = this.parseExpression(tokens, true, scopeBuilder);
        ParserUtil.checkReturnType(value, returnType);
        String id = identifier.getContent();
        return switch (value.returnType()) {
            case Returnable.ReturnType.NUMBER -> new NumAssignmentNode(value, identifier.getPosition(), scopeBuilder.num(id));
            case Returnable.ReturnType.STRING -> new StrAssignmentNode((Returnable<String>)value, identifier.getPosition(), scopeBuilder.str(id));
            case Returnable.ReturnType.BOOLEAN -> new BoolAssignmentNode((Returnable<Boolean>)value, identifier.getPosition(), scopeBuilder.bool(id));
            default -> throw new ParseException("Illegal type for variable declaration: " + type, value.getPosition());
        };
    }

    private Block parseBlock(Tokenizer tokens, boolean loop, Scope.ScopeBuilder scopeBuilder) {
        Token token;
        ArrayList parsedItems = new ArrayList();
        scopeBuilder = scopeBuilder.sub();
        Token first = tokens.get();
        while (tokens.hasNext() && !(token = tokens.get()).getType().equals((Object)Token.Type.BLOCK_END)) {
            Item<?> parsedItem = this.parseItem(tokens, loop, scopeBuilder);
            if (parsedItem != Function.NULL) {
                parsedItems.add(parsedItem);
            }
            if (!tokens.hasNext() || token.isLoopLike()) continue;
            ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        }
        return new Block(parsedItems, first.getPosition());
    }

    private Item<?> parseItem(Tokenizer tokens, boolean loop, Scope.ScopeBuilder scopeBuilder) {
        Token token = tokens.get();
        if (loop) {
            ParserUtil.checkType(token, Token.Type.IDENTIFIER, Token.Type.IF_STATEMENT, Token.Type.WHILE_LOOP, Token.Type.FOR_LOOP, Token.Type.NUMBER_VARIABLE, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.RETURN, Token.Type.BREAK, Token.Type.CONTINUE, Token.Type.FAIL);
        } else {
            ParserUtil.checkType(token, Token.Type.IDENTIFIER, Token.Type.IF_STATEMENT, Token.Type.WHILE_LOOP, Token.Type.FOR_LOOP, Token.Type.NUMBER_VARIABLE, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.RETURN, Token.Type.FAIL);
        }
        if (token.isLoopLike()) {
            return this.parseLoopLike(tokens, loop, scopeBuilder);
        }
        if (token.isIdentifier()) {
            if (scopeBuilder.contains(token.getContent())) {
                return this.parseAssignment(tokens, scopeBuilder);
            }
            return this.parseFunction(tokens, true, scopeBuilder);
        }
        if (token.isVariableDeclaration()) {
            return this.parseVariableDeclaration(tokens, scopeBuilder);
        }
        if (token.getType().equals((Object)Token.Type.RETURN)) {
            return new ReturnKeyword(tokens.consume().getPosition());
        }
        if (token.getType().equals((Object)Token.Type.BREAK)) {
            return new BreakKeyword(tokens.consume().getPosition());
        }
        if (token.getType().equals((Object)Token.Type.CONTINUE)) {
            return new ContinueKeyword(tokens.consume().getPosition());
        }
        if (token.getType().equals((Object)Token.Type.FAIL)) {
            return new FailKeyword(tokens.consume().getPosition());
        }
        throw new UnsupportedOperationException("Unexpected token " + token.getType() + ": " + token.getPosition());
    }

    private VariableAssignmentNode<?> parseAssignment(Tokenizer tokens, Scope.ScopeBuilder scopeBuilder) {
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IDENTIFIER);
        ParserUtil.checkType(tokens.consume(), Token.Type.ASSIGNMENT);
        Returnable<Number> value = this.parseExpression(tokens, true, scopeBuilder);
        String id = identifier.getContent();
        ParserUtil.checkReturnType(value, scopeBuilder.getType(id));
        Returnable.ReturnType type = value.returnType();
        return switch (type) {
            case Returnable.ReturnType.NUMBER -> new NumAssignmentNode(value, identifier.getPosition(), scopeBuilder.getIndex(id));
            case Returnable.ReturnType.STRING -> new StrAssignmentNode((Returnable<String>)value, identifier.getPosition(), scopeBuilder.getIndex(id));
            case Returnable.ReturnType.BOOLEAN -> new BoolAssignmentNode((Returnable<Boolean>)value, identifier.getPosition(), scopeBuilder.getIndex(id));
            default -> throw new ParseException("Illegal type for variable assignment: " + type, value.getPosition());
        };
    }

    private Function<?> parseFunction(Tokenizer tokens, boolean fullStatement, Scope.ScopeBuilder scopeBuilder) {
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IDENTIFIER);
        if (!this.functions.containsKey(identifier.getContent())) {
            throw new ParseException("No such function \"" + identifier.getContent() + "\"", identifier.getPosition());
        }
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_BEGIN);
        List<Returnable<?>> args = this.getArgs(tokens, scopeBuilder);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        if (fullStatement) {
            ParserUtil.checkType(tokens.get(), Token.Type.STATEMENT_END);
        }
        if (this.ignoredFunctions.contains(identifier.getContent())) {
            return Function.NULL;
        }
        if (this.functions.containsKey(identifier.getContent())) {
            FunctionBuilder<Function<?>> builder = this.functions.get(identifier.getContent());
            if (builder.argNumber() != -1 && args.size() != builder.argNumber()) {
                throw new ParseException("Expected " + builder.argNumber() + " arguments, found " + args.size(), identifier.getPosition());
            }
            for (int i = 0; i < args.size(); ++i) {
                Returnable<?> argument = args.get(i);
                if (builder.getArgument(i) == null) {
                    throw new ParseException("Unexpected argument at position " + i + " in function " + identifier.getContent(), identifier.getPosition());
                }
                ParserUtil.checkReturnType(argument, builder.getArgument(i));
            }
            return builder.build(args, identifier.getPosition());
        }
        throw new UnsupportedOperationException("Unsupported function: " + identifier.getContent());
    }

    private List<Returnable<?>> getArgs(Tokenizer tokens, Scope.ScopeBuilder scopeBuilder) {
        ArrayList args = new ArrayList();
        while (!tokens.get().getType().equals((Object)Token.Type.GROUP_END)) {
            args.add(this.parseExpression(tokens, true, scopeBuilder));
            ParserUtil.checkType(tokens.get(), Token.Type.SEPARATOR, Token.Type.GROUP_END);
            if (!tokens.get().getType().equals((Object)Token.Type.SEPARATOR)) continue;
            tokens.consume();
        }
        return args;
    }
}

