/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.holder;

import com.dfsek.terra.addons.biome.holder.PaletteHolder;
import com.dfsek.terra.api.world.chunk.generation.util.Palette;
import java.util.Map;
import java.util.TreeMap;

public class PaletteHolderBuilder {
    private final TreeMap<Integer, Palette> paletteMap = new TreeMap();

    public PaletteHolderBuilder add(int y, Palette palette) {
        this.paletteMap.put(y, palette);
        return this;
    }

    public PaletteHolder build() {
        int min = Math.min(this.paletteMap.keySet().stream().min(Integer::compareTo).orElse(0), 0);
        int max = Math.max(this.paletteMap.keySet().stream().max(Integer::compareTo).orElse(255), 255);
        Palette[] palettes = new Palette[this.paletteMap.lastKey() + 1 - min];
        for (int y = min; y <= Math.max(this.paletteMap.lastKey(), max); ++y) {
            Palette d = null;
            for (Map.Entry<Integer, Palette> e : this.paletteMap.entrySet()) {
                if (e.getKey() < y) continue;
                d = e.getValue();
                break;
            }
            if (d == null) {
                throw new IllegalArgumentException("No palette for Y=" + y);
            }
            palettes[y - min] = d;
        }
        return new PaletteHolder(palettes, -min);
    }
}

