/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.provider.providers;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.ess3.provider.MaterialTagProvider;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;

public class BukkitMaterialTagProvider
implements MaterialTagProvider {
    private final Map<String, Tag<Material>> stringToTagMap = new HashMap<String, Tag<Material>>();

    @Override
    public boolean tagExists(String tagName) {
        if (tagName == null) {
            return false;
        }
        return this.getTag(tagName) != null;
    }

    @Override
    public boolean isTagged(String tagName, Material material) {
        if (tagName == null || material == null) {
            return false;
        }
        Tag<Material> tag = this.getTag(tagName);
        return tag != null && tag.isTagged((Keyed)material);
    }

    private Tag<Material> getTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        if (!this.stringToTagMap.containsKey(tagName = tagName.toUpperCase())) {
            try {
                Field field = Tag.class.getDeclaredField(tagName.toUpperCase());
                this.stringToTagMap.put(tagName, (Tag<Material>)((Tag)field.get(null)));
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                this.stringToTagMap.put(tagName, null);
            }
        }
        return this.stringToTagMap.get(tagName);
    }
}

