/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl.providers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.ess3.nms.refl.ReflUtil;
import net.ess3.provider.SpawnerBlockProvider;
import org.bukkit.block.CreatureSpawner;

public class ReflSpawnerBlockProvider
implements SpawnerBlockProvider {
    @Override
    public void setMaxSpawnDelay(CreatureSpawner spawner, int delay) {
        Class<?> mobSpawnerAbstract = ReflUtil.getNMSClass("MobSpawnerAbstract");
        Field maxSpawnDelay = ReflUtil.getFieldCached(mobSpawnerAbstract, "maxSpawnDelay");
        if (maxSpawnDelay != null) {
            try {
                maxSpawnDelay.setInt(this.getNMSSpawner(spawner), delay);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setMinSpawnDelay(CreatureSpawner spawner, int delay) {
        Class<?> mobSpawnerAbstract = ReflUtil.getNMSClass("MobSpawnerAbstract");
        Field minSpawnDelay = ReflUtil.getFieldCached(mobSpawnerAbstract, "minSpawnDelay");
        if (minSpawnDelay != null) {
            try {
                minSpawnDelay.setInt(this.getNMSSpawner(spawner), delay);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDescription() {
        return "Reflection based provider";
    }

    private Object getNMSSpawner(CreatureSpawner spawner) {
        try {
            Class<?> craftWorld = ReflUtil.getOBCClass("CraftWorld");
            Class<?> tileEntityMobSpawner = ReflUtil.getNMSClass("TileEntityMobSpawner");
            Method getSpawner = ReflUtil.getMethodCached(tileEntityMobSpawner, "getSpawner");
            Method getTileEntityAt = ReflUtil.getMethodCached(craftWorld, "getTileEntityAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            if (getSpawner != null && getTileEntityAt != null) {
                Object craftTileEntity = getTileEntityAt.invoke((Object)spawner.getWorld(), spawner.getX(), spawner.getY(), spawner.getZ());
                return getSpawner.invoke(craftTileEntity, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

