/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl.providers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Locale;
import net.ess3.nms.refl.ReflUtil;
import net.ess3.provider.PersistentDataProvider;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ReflPersistentDataProvider
implements PersistentDataProvider {
    private static final String PDC_ROOT_TAG = "PublicBukkitValues";
    private static final String ROOT_TAG = "tag";
    private final String namespace;
    private final MethodHandle itemHandleGetterHandle;
    private final MethodHandle getTagHandle;
    private final MethodHandle tagSetterHandle;
    private final MethodHandle newCompoundHandle;
    private final MethodHandle getCompoundHandle;
    private final MethodHandle setCompoundHandle;
    private final MethodHandle setStringHandle;
    private final MethodHandle removeHandle;
    private final MethodHandle getStringHandle;

    public ReflPersistentDataProvider(Plugin plugin) {
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        MethodHandle itemHandleGetterHandle = null;
        MethodHandle getTagHandle = null;
        MethodHandle tagSetterHandle = null;
        MethodHandle newCompoundHandle = null;
        MethodHandle getCompoundHandle = null;
        MethodHandle setCompoundHandle = null;
        MethodHandle setStringHandle = null;
        MethodHandle removeHandle = null;
        MethodHandle getStringHandle = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field handleGetter = ReflUtil.getOBCClass("inventory.CraftItemStack").getDeclaredField("handle");
            handleGetter.setAccessible(true);
            itemHandleGetterHandle = lookup.unreflectGetter(handleGetter);
            Field tagSetter = ReflUtil.getNMSClass("ItemStack").getDeclaredField(ROOT_TAG);
            tagSetter.setAccessible(true);
            tagSetterHandle = lookup.unreflectSetter(tagSetter);
            getTagHandle = lookup.findVirtual(ReflUtil.getNMSClass("ItemStack"), "getTag", MethodType.methodType(ReflUtil.getNMSClass("NBTTagCompound")));
            newCompoundHandle = lookup.findConstructor(ReflUtil.getNMSClass("NBTTagCompound"), MethodType.methodType(Void.TYPE));
            getCompoundHandle = lookup.findVirtual(ReflUtil.getNMSClass("NBTTagCompound"), "getCompound", MethodType.methodType(ReflUtil.getNMSClass("NBTTagCompound"), String.class));
            setCompoundHandle = lookup.findVirtual(ReflUtil.getNMSClass("NBTTagCompound"), "set", MethodType.methodType(Void.TYPE, String.class, ReflUtil.getNMSClass("NBTBase")));
            setStringHandle = lookup.findVirtual(ReflUtil.getNMSClass("NBTTagCompound"), "setString", MethodType.methodType(Void.TYPE, String.class, String.class));
            removeHandle = lookup.findVirtual(ReflUtil.getNMSClass("NBTTagCompound"), "remove", MethodType.methodType(Void.TYPE, String.class));
            getStringHandle = lookup.findVirtual(ReflUtil.getNMSClass("NBTTagCompound"), "getString", MethodType.methodType(String.class, String.class));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.itemHandleGetterHandle = itemHandleGetterHandle;
        this.getTagHandle = getTagHandle;
        this.tagSetterHandle = tagSetterHandle;
        this.newCompoundHandle = newCompoundHandle;
        this.getCompoundHandle = getCompoundHandle;
        this.setCompoundHandle = setCompoundHandle;
        this.setStringHandle = setStringHandle;
        this.removeHandle = removeHandle;
        this.getStringHandle = getStringHandle;
    }

    private String getPersistentString(ItemStack itemStack, String key) throws Throwable {
        Object nmsItem = this.itemHandleGetterHandle.invoke(itemStack);
        Object itemRootTag = this.getTagHandle.invoke(nmsItem);
        if (itemRootTag == null) {
            return null;
        }
        Object tagCompound = this.getCompoundHandle.invoke(itemRootTag, ROOT_TAG);
        Object publicBukkitValuesCompound = this.getCompoundHandle.invoke(tagCompound, PDC_ROOT_TAG);
        return this.getStringHandle.invoke(publicBukkitValuesCompound, key);
    }

    private void setPersistentString(ItemStack itemStack, String key, String value) throws Throwable {
        Object nmsItem = this.itemHandleGetterHandle.invoke(itemStack);
        Object itemRootTag = this.getTagHandle.invoke(nmsItem);
        if (itemRootTag == null) {
            itemRootTag = this.newCompoundHandle.invoke();
            this.tagSetterHandle.invoke(nmsItem, itemRootTag);
        }
        Object tagCompound = this.getCompoundHandle.invoke(itemRootTag, ROOT_TAG);
        Object publicBukkitValuesCompound = this.getCompoundHandle.invoke(tagCompound, PDC_ROOT_TAG);
        if (value == null) {
            this.removeHandle.invoke(publicBukkitValuesCompound, key);
        } else {
            this.setStringHandle.invoke(publicBukkitValuesCompound, key, value);
        }
        this.setCompoundHandle.invoke(tagCompound, PDC_ROOT_TAG, publicBukkitValuesCompound);
        this.setCompoundHandle.invoke(itemRootTag, ROOT_TAG, tagCompound);
    }

    @Override
    public void set(ItemStack itemStack, String key, String value) {
        try {
            this.setPersistentString(itemStack, this.namespace + ":" + key, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getString(ItemStack itemStack, String key) {
        try {
            return this.getPersistentString(itemStack, this.namespace + ":" + key);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public void remove(ItemStack itemStack, String key) {
        try {
            this.setPersistentString(itemStack, this.namespace + ":" + key, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "1.13 >= Persistent Data Container Provider";
    }
}

