/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.google.common.primitives.Chars;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class StringUtil {
    private static final Pattern INVALIDFILECHARS = Pattern.compile("[^a-z0-9-]");
    private static final Pattern STRICTINVALIDCHARS = Pattern.compile("[^a-z0-9]");
    private static final Pattern INVALIDCHARS = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\ud7ff\ue000-\ufffc]");

    private StringUtil() {
    }

    public static String sanitizeFileName(String name) {
        return INVALIDFILECHARS.matcher(name.toLowerCase(Locale.ENGLISH)).replaceAll("_");
    }

    public static String safeString(String string) {
        if (string == null) {
            return null;
        }
        return STRICTINVALIDCHARS.matcher(string.toLowerCase(Locale.ENGLISH)).replaceAll("_");
    }

    public static String sanitizeString(String string) {
        return INVALIDCHARS.matcher(string).replaceAll("");
    }

    public static String joinList(Object ... list) {
        return StringUtil.joinList(", ", list);
    }

    public static String joinList(String seperator, Object ... list) {
        StringBuilder buf = new StringBuilder();
        for (Object each : list) {
            if (buf.length() > 0) {
                buf.append(seperator);
            }
            if (each instanceof Collection) {
                buf.append(StringUtil.joinList(seperator, ((Collection)each).toArray()));
                continue;
            }
            try {
                buf.append(each.toString());
            }
            catch (Exception e) {
                buf.append(each.toString());
            }
        }
        return buf.toString();
    }

    public static String joinListSkip(String seperator, String skip, Object ... list) {
        StringBuilder buf = new StringBuilder();
        for (Object each : list) {
            if (each.toString().equalsIgnoreCase(skip)) continue;
            if (buf.length() > 0) {
                buf.append(seperator);
            }
            if (each instanceof Collection) {
                buf.append(StringUtil.joinListSkip(seperator, skip, ((Collection)each).toArray()));
                continue;
            }
            try {
                buf.append(each.toString());
            }
            catch (Exception e) {
                buf.append(each.toString());
            }
        }
        return buf.toString();
    }

    public static UUID toUUID(String input) {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static String abbreviate(String input, int length) {
        if (input == null) {
            return null;
        }
        if (length < 4) {
            throw new IllegalArgumentException("Invalid length " + length);
        }
        if (input.length() <= length) {
            return input;
        }
        return input.substring(0, length - 3) + "...";
    }

    public static String stripToNull(String input) {
        if (input == null) {
            return null;
        }
        String result = StringUtil.strip(input);
        return result.isEmpty() ? null : result;
    }

    public static String strip(String input) {
        return StringUtil.strip(input, Character::isWhitespace);
    }

    public static String strip(String input, String stripChars) {
        if (stripChars == null) {
            return StringUtil.strip(input);
        }
        List toStrip = Chars.asList((char[])stripChars.toCharArray());
        return StringUtil.strip(input, toStrip::contains);
    }

    public static String strip(String input, Function<Character, Boolean> shouldStrip) {
        int startIndex;
        if (input == null) {
            return null;
        }
        int endIndex = input.length();
        for (startIndex = 0; startIndex < endIndex && shouldStrip.apply(Character.valueOf(input.charAt(startIndex))).booleanValue(); ++startIndex) {
        }
        while (endIndex > startIndex && shouldStrip.apply(Character.valueOf(input.charAt(endIndex - 1))).booleanValue()) {
            --endIndex;
        }
        return input.substring(startIndex, endIndex);
    }
}

