/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

public final class DownsampleUtil {
    private static final NamedTextColor[] VALUES = new NamedTextColor[]{new NamedTextColor("0", 0), new NamedTextColor("1", 170), new NamedTextColor("2", 43520), new NamedTextColor("3", 43690), new NamedTextColor("4", 0xAA0000), new NamedTextColor("5", 0xAA00AA), new NamedTextColor("6", 0xFFAA00), new NamedTextColor("7", 0xAAAAAA), new NamedTextColor("8", 0x555555), new NamedTextColor("9", 0x5555FF), new NamedTextColor("a", 0x55FF55), new NamedTextColor("b", 0x55FFFF), new NamedTextColor("c", 0xFF5555), new NamedTextColor("d", 0xFF55FF), new NamedTextColor("e", 0xFFFF55), new NamedTextColor("f", 0xFFFFFF)};

    private DownsampleUtil() {
    }

    public static String nearestTo(int rgb) {
        HSVLike any = HSVLike.fromRGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        float matchedDistance = Float.MAX_VALUE;
        NamedTextColor match = VALUES[0];
        for (NamedTextColor potential : VALUES) {
            float distance = DownsampleUtil.distance(any, potential.hsv);
            if (distance < matchedDistance) {
                match = potential;
                matchedDistance = distance;
            }
            if (distance == 0.0f) break;
        }
        return match.code;
    }

    private static float distance(HSVLike self, HSVLike other) {
        float hueDistance = 3.0f * Math.abs(self.h() - other.h());
        float saturationDiff = self.s() - other.s();
        float valueDiff = self.v() - other.v();
        return hueDistance * hueDistance + saturationDiff * saturationDiff + valueDiff * valueDiff;
    }

    private static final class HSVLike {
        private final float h;
        private final float s;
        private final float v;

        private HSVLike(float h, float s, float v) {
            this.h = h;
            this.s = s;
            this.v = v;
        }

        public float h() {
            return this.h;
        }

        public float s() {
            return this.s;
        }

        public float v() {
            return this.v;
        }

        static HSVLike fromRGB(int red, int green, int blue) {
            float r = (float)red / 255.0f;
            float g = (float)green / 255.0f;
            float b = (float)blue / 255.0f;
            float min = Math.min(r, Math.min(g, b));
            float max = Math.max(r, Math.max(g, b));
            float delta = max - min;
            float s = max != 0.0f ? delta / max : 0.0f;
            if (s == 0.0f) {
                return new HSVLike(0.0f, s, max);
            }
            float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
            return new HSVLike(h / 360.0f, s, max);
        }
    }

    private static final class NamedTextColor {
        private final String code;
        private final int value;
        private final HSVLike hsv;

        private NamedTextColor(String code, int value) {
            this.code = code;
            this.value = value;
            this.hsv = HSVLike.fromRGB(this.red(), this.green(), this.blue());
        }

        private int red() {
            return this.value >> 16 & 0xFF;
        }

        private int green() {
            return this.value >> 8 & 0xFF;
        }

        private int blue() {
            return this.value & 0xFF;
        }
    }
}

