/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.userstorage;

import com.earth2me.essentials.utils.StringUtil;
import com.google.common.io.Files;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import net.ess3.api.IEssentials;

public class ModernUUIDCache {
    private final IEssentials ess;
    private final ConcurrentHashMap<String, UUID> nameToUuidMap = new ConcurrentHashMap();
    private final Set<UUID> uuidCache = ConcurrentHashMap.newKeySet();
    private final ScheduledExecutorService writeExecutor = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean pendingNameWrite = new AtomicBoolean(false);
    private final AtomicBoolean pendingUuidWrite = new AtomicBoolean(false);
    private final File nameToUuidFile;
    private final File uuidCacheFile;

    public ModernUUIDCache(IEssentials ess) {
        this.ess = ess;
        this.nameToUuidFile = new File(ess.getDataFolder(), "usermap.bin");
        this.uuidCacheFile = new File(ess.getDataFolder(), "uuids.bin");
        this.loadCache();
        this.writeExecutor.scheduleWithFixedDelay(() -> {
            if (this.pendingNameWrite.compareAndSet(true, false)) {
                this.saveNameToUuidCache();
            }
            if (this.pendingUuidWrite.compareAndSet(true, false)) {
                this.saveUuidCache();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    protected UUID getCachedUUID(String name) {
        return this.nameToUuidMap.get(this.getSanitizedName(name));
    }

    protected Set<UUID> getCachedUUIDs() {
        return Collections.unmodifiableSet(this.uuidCache);
    }

    protected Map<String, UUID> getNameCache() {
        return Collections.unmodifiableMap(this.nameToUuidMap);
    }

    protected int getCacheSize() {
        return this.uuidCache.size();
    }

    protected String getSanitizedName(String name) {
        return this.ess.getSettings().isSafeUsermap() ? StringUtil.safeString(name) : name;
    }

    protected void updateCache(UUID uuid, String name) {
        String sanitizedName;
        UUID replacedUuid;
        if (this.uuidCache.add(uuid)) {
            this.pendingUuidWrite.set(true);
        }
        if (name != null && !uuid.equals(replacedUuid = this.nameToUuidMap.put(sanitizedName = this.getSanitizedName(name), uuid))) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.WARNING, "Replaced UUID during cache update for " + sanitizedName + ": " + replacedUuid + " -> " + uuid);
            }
            this.pendingNameWrite.set(true);
        }
    }

    protected void removeCache(UUID uuid) {
        if (uuid == null) {
            return;
        }
        if (this.uuidCache.remove(uuid)) {
            this.pendingUuidWrite.set(true);
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, UUID> entry : this.nameToUuidMap.entrySet()) {
            if (!uuid.equals(entry.getValue())) continue;
            toRemove.add(entry.getKey());
        }
        for (String name : toRemove) {
            this.nameToUuidMap.remove(name);
        }
        if (!toRemove.isEmpty()) {
            this.pendingNameWrite.set(true);
        }
    }

    private void loadCache() {
        DataInputStream dis;
        boolean debug = this.ess.getSettings().isDebug();
        try {
            if (!this.nameToUuidFile.exists()) {
                if (!this.nameToUuidFile.createNewFile()) {
                    throw new RuntimeException("Error while creating usermap.bin");
                }
                return;
            }
            if (debug) {
                this.ess.getLogger().log(Level.INFO, "Loading Name->UUID cache from disk...");
            }
            this.nameToUuidMap.clear();
            dis = new DataInputStream(new FileInputStream(this.nameToUuidFile));
            try {
                while (dis.available() > 0) {
                    UUID uuid;
                    String username = dis.readUTF();
                    UUID previous = this.nameToUuidMap.put(username, uuid = new UUID(dis.readLong(), dis.readLong()));
                    if (previous == null || !debug) continue;
                    this.ess.getLogger().log(Level.WARNING, "Replaced UUID during cache load for " + username + ": " + previous + " -> " + uuid);
                }
            }
            finally {
                dis.close();
            }
        }
        catch (IOException e) {
            this.ess.getLogger().log(Level.SEVERE, "Error while loading Name->UUID cache", e);
        }
        try {
            if (!this.uuidCacheFile.exists()) {
                if (!this.uuidCacheFile.createNewFile()) {
                    throw new RuntimeException("Error while creating uuids.bin");
                }
                return;
            }
            if (debug) {
                this.ess.getLogger().log(Level.INFO, "Loading UUID cache from disk...");
            }
            this.uuidCache.clear();
            dis = new DataInputStream(new FileInputStream(this.uuidCacheFile));
            try {
                while (dis.available() > 0) {
                    UUID uuid = new UUID(dis.readLong(), dis.readLong());
                    if (this.uuidCache.contains(uuid) && debug) {
                        this.ess.getLogger().log(Level.WARNING, "UUID " + uuid + " duplicated in cache");
                    }
                    this.uuidCache.add(uuid);
                }
            }
            finally {
                dis.close();
            }
        }
        catch (IOException e) {
            this.ess.getLogger().log(Level.SEVERE, "Error while loading UUID cache", e);
        }
    }

    private void saveUuidCache() {
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "Saving UUID cache to disk...");
        }
        try {
            File tmpMap = File.createTempFile("uuids", ".tmp.bin", this.ess.getDataFolder());
            ModernUUIDCache.writeUuidCache(tmpMap, this.uuidCache);
            Files.move((File)tmpMap, (File)this.uuidCacheFile);
        }
        catch (IOException e) {
            this.ess.getLogger().log(Level.SEVERE, "Error while saving UUID cache", e);
        }
    }

    private void saveNameToUuidCache() {
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().log(Level.INFO, "Saving Name->UUID cache to disk...");
        }
        try {
            File tmpMap = File.createTempFile("usermap", ".tmp.bin", this.ess.getDataFolder());
            ModernUUIDCache.writeNameUuidMap(tmpMap, this.nameToUuidMap);
            Files.move((File)tmpMap, (File)this.nameToUuidFile);
        }
        catch (IOException e) {
            this.ess.getLogger().log(Level.SEVERE, "Error while saving Name->UUID cache", e);
        }
    }

    protected void blockingSave() {
        this.saveUuidCache();
        this.saveNameToUuidCache();
    }

    public static void writeUuidCache(File file, Set<UUID> uuids) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            for (UUID uuid : uuids) {
                dos.writeLong(uuid.getMostSignificantBits());
                dos.writeLong(uuid.getLeastSignificantBits());
            }
        }
    }

    public static void writeNameUuidMap(File file, Map<String, UUID> nameToUuidMap) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            for (Map.Entry<String, UUID> entry : nameToUuidMap.entrySet()) {
                dos.writeUTF(entry.getKey());
                UUID uuid = entry.getValue();
                dos.writeLong(uuid.getMostSignificantBits());
                dos.writeLong(uuid.getLeastSignificantBits());
            }
        }
    }

    public void shutdown() {
        this.writeExecutor.shutdownNow();
        this.blockingSave();
    }
}

