/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.textreader;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.textreader.IText;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BookPager {
    final double pageMax = 254.0;
    final double charMax = 18.5;
    final int lineMax = 12;
    private final transient IText text;

    public BookPager(IText text) {
        this.text = text;
    }

    public List<String> getPages(String pageStr) throws Exception {
        int chapterstart;
        String line;
        int chapterend;
        List<String> lines = this.text.getLines();
        ArrayList<String> pageLines = new ArrayList<String>();
        Map<String, Integer> bookmarks = this.text.getBookmarks();
        if (!bookmarks.containsKey(pageStr.toLowerCase(Locale.ENGLISH))) {
            throw new Exception(I18n.tl("infoUnknownChapter", new Object[0]));
        }
        for (chapterend = chapterstart = bookmarks.get(pageStr.toLowerCase(Locale.ENGLISH)) + 1; chapterend < lines.size() && ((line = lines.get(chapterend)).length() <= 0 || line.charAt(0) != '#'); ++chapterend) {
        }
        ArrayList<String> pages = new ArrayList<String>();
        double pageLength = 0.0;
        for (int lineNo = chapterstart; lineNo < chapterend; ++lineNo) {
            String tempLine;
            String pageLine = lines.get(lineNo);
            int lineLength = pageLine.length();
            double length = 0.0;
            int pointer = 0;
            int start = 0;
            double weight = 1.0;
            boolean forcePageEnd = false;
            while (pointer < lineLength) {
                char letter = pageLine.charAt(pointer);
                if (pageLine.charAt(start) == ' ') {
                    ++start;
                    ++pointer;
                    continue;
                }
                if (pageLength >= 254.0) {
                    length = 18.5;
                    pageLength = 0.0;
                    forcePageEnd = true;
                }
                if (length >= 18.5 || letter == '\u00a7' && length + 1.0 >= 18.5) {
                    int pos;
                    int rollback = 0;
                    for (pos = pointer; pos > start && pageLine.charAt(pos) != ' ' && pageLine.charAt(pos) != "\n".charAt(0); --pos) {
                        ++rollback;
                    }
                    if (pos != start) {
                        pointer = pos;
                        pageLength -= (double)rollback;
                    }
                    tempLine = pageLine.substring(start, pointer);
                    pageLines.add(tempLine);
                    if (this.buildPage(pages, pageLines, forcePageEnd)) {
                        pageLength = 0.0;
                    }
                    forcePageEnd = false;
                    start = pointer;
                    length = 0.0;
                    pageLength += 1.0;
                }
                pageLength += 1.0;
                if (letter == '\u00a7' && pointer + 1 < lineLength) {
                    char nextLetter = pageLine.charAt(pointer + 1);
                    weight = nextLetter == 'l' || nextLetter == 'L' ? 1.25 : 1.0;
                    ++pointer;
                } else {
                    length = letter == 'i' || letter == '.' || letter == ',' || letter == '!' || letter == ':' || letter == ';' || letter == '|' ? (length += 0.34 * weight) : (letter == 'l' || letter == '\'' || letter == '`' ? (length += 0.53 * weight) : (letter == ' ' || letter == 't' || letter == 'I' || letter == '[' || letter == ']' ? (length += 0.69 * weight) : (letter == 'f' || letter == 'k' || letter == '\"' || letter == '*' || letter == '(' || letter == ')' || letter == '{' || letter == '}' || letter == '<' || letter == '>' ? (length += 0.85 * weight) : (letter == '@' || letter == '~' ? (length += 1.2 * weight) : (length += weight)))));
                }
                ++pointer;
            }
            if (!(length > 0.0)) continue;
            tempLine = pageLine.substring(start, lineLength);
            pageLines.add(tempLine);
            if (!this.buildPage(pages, pageLines, false)) continue;
            pageLength = 0.0;
        }
        this.buildPage(pages, pageLines, true);
        return pages;
    }

    boolean buildPage(List<String> pages, List<String> lines, boolean override) {
        if (override || lines.size() > 12) {
            StringBuilder newPage = new StringBuilder();
            for (String aline : lines) {
                newPage.append(aline).append("\n");
            }
            pages.add(newPage.toString());
            lines.clear();
            return true;
        }
        return false;
    }
}

