/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import java.math.BigDecimal;
import net.ess3.api.IEssentials;
import net.ess3.api.MaxMoneyException;
import org.bukkit.inventory.ItemStack;

public class SignSell
extends EssentialsSign {
    public SignSell() {
        super("Sell");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        this.validateTrade(sign, 1, 2, player, ess);
        this.validateTrade(sign, 3, ess);
        return true;
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException, ChargeException, MaxMoneyException {
        Trade charge = this.getTrade(sign, 1, 2, player, ess);
        Trade money = this.getTrade(sign, 3, ess);
        if (ess.getSettings().isAllowBulkBuySell() && player.getBase().isSneaking()) {
            ItemStack heldItem = player.getItemInHand();
            if (charge.getItemStack().isSimilar(heldItem)) {
                int initialItemAmount = charge.getItemStack().getAmount();
                int newItemAmount = heldItem.getAmount();
                ItemStack item = charge.getItemStack();
                item.setAmount(newItemAmount);
                charge = new Trade(item, ess);
                BigDecimal chargeAmount = money.getMoney();
                BigDecimal pricePerSingleItem = chargeAmount.divide(new BigDecimal(initialItemAmount));
                pricePerSingleItem = pricePerSingleItem.multiply(new BigDecimal(newItemAmount));
                money = new Trade(pricePerSingleItem, ess);
            }
        }
        charge.isAffordableFor(player);
        money.pay(player, Trade.OverflowType.DROP);
        charge.charge(player);
        Trade.log("Sign", "Sell", "Interact", username, charge, username, money, sign.getBlock().getLocation(), player.getMoney(), ess);
        return true;
    }
}

