/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import java.util.ArrayList;
import java.util.ListIterator;
import net.ess3.api.IEssentials;
import net.essentialsx.api.v2.services.mail.MailMessage;

public class SignMail
extends EssentialsSign {
    public SignMail() {
        super("Mail");
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        ArrayList<MailMessage> mail = player.getMailMessages();
        ListIterator<MailMessage> iterator = mail.listIterator();
        boolean hadMail = false;
        while (iterator.hasNext()) {
            MailMessage mailObj = iterator.next();
            if (mailObj.isExpired()) {
                iterator.remove();
                continue;
            }
            hadMail = true;
            player.sendMessage(ess.getMail().getMailLine(mailObj));
            iterator.set(new MailMessage(true, mailObj.isLegacy(), mailObj.getSenderUsername(), mailObj.getSenderUUID(), mailObj.getTimeSent(), mailObj.getTimeExpire(), mailObj.getMessage()));
        }
        if (!hadMail) {
            player.sendMessage(I18n.tl("noNewMail", new Object[0]));
            return false;
        }
        player.setMailList(mail);
        player.sendMessage(I18n.tl("markMailAsRead", new Object[0]));
        return true;
    }
}

