/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Server;

public class Commandwarpinfo
extends EssentialsCommand {
    public Commandwarpinfo() {
        super("warpinfo");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        String name = args[0];
        Location loc = this.ess.getWarps().getWarp(name);
        sender.sendMessage(I18n.tl("warpInfo", name));
        sender.sendMessage(I18n.tl("whoisLocation", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            if (this.ess.getSettings().getPerWarpPermission() && sender.isPlayer()) {
                ArrayList<String> list = new ArrayList<String>();
                for (String curWarp : this.ess.getWarps().getList()) {
                    if (!sender.isAuthorized("essentials.warps." + curWarp, this.ess)) continue;
                    list.add(curWarp);
                }
                return list;
            }
            return new ArrayList<String>(this.ess.getWarps().getList());
        }
        return Collections.emptyList();
    }
}

