/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.Inventories;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandunlimited
extends EssentialsCommand {
    public Commandunlimited() {
        super("unlimited");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        User target = user;
        if (args.length > 1 && user.isAuthorized("essentials.unlimited.others")) {
            target = this.getPlayer(server, user, args, 1);
        }
        if (args[0].equalsIgnoreCase("list")) {
            user.sendMessage(this.getList(target));
        } else if (args[0].equalsIgnoreCase("clear")) {
            for (Material m : new HashSet<Material>(target.getUnlimited())) {
                if (m == null) continue;
                this.toggleUnlimited(user, target, m.toString());
            }
        } else {
            this.toggleUnlimited(user, target, args[0]);
        }
    }

    private String getList(User target) {
        StringBuilder output = new StringBuilder();
        output.append(I18n.tl("unlimitedItems", new Object[0])).append(" ");
        Set<Material> items = target.getUnlimited();
        if (items.isEmpty()) {
            output.append(I18n.tl("none", new Object[0]));
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (Material material : items) {
            if (material == null) continue;
            joiner.add(material.toString().toLowerCase(Locale.ENGLISH).replace("_", ""));
        }
        output.append(joiner.toString());
        return output.toString();
    }

    private void toggleUnlimited(User user, User target, String item) throws Exception {
        ItemStack stack = this.ess.getItemDb().get(item, 1);
        stack.setAmount(Math.min(stack.getType().getMaxStackSize(), 2));
        String itemname = stack.getType().toString().toLowerCase(Locale.ENGLISH).replace("_", "");
        if (this.ess.getSettings().permissionBasedItemSpawn() && !user.isAuthorized("essentials.unlimited.item-all") && !user.isAuthorized("essentials.unlimited.item-" + itemname) && (stack.getType() != Material.WATER_BUCKET && stack.getType() != Material.LAVA_BUCKET || !user.isAuthorized("essentials.unlimited.item-bucket"))) {
            throw new Exception(I18n.tl("unlimitedItemPermission", itemname));
        }
        String message = "disableUnlimited";
        boolean enableUnlimited = false;
        if (!target.hasUnlimited(stack)) {
            message = "enableUnlimited";
            enableUnlimited = true;
            if (!Inventories.containsAtLeast(target.getBase(), stack, stack.getAmount())) {
                Inventories.addItem(target.getBase(), stack);
            }
        }
        if (user != target) {
            user.sendMessage(I18n.tl(message, itemname, target.getDisplayName()));
        }
        target.sendMessage(I18n.tl(message, itemname, target.getDisplayName()));
        target.setUnlimited(stack, enableUnlimited);
    }
}

