/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.OfflinePlayerStub;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.utils.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.events.UserTeleportHomeEvent;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandhome
extends EssentialsCommand {
    public Commandhome() {
        super("home");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        Trade charge = new Trade(this.getName(), this.ess);
        User player = user;
        String homeName = "";
        if (args.length > 0) {
            String[] nameParts = args[0].split(":");
            if (nameParts[0].length() == args[0].length() || !user.isAuthorized("essentials.home.others")) {
                homeName = nameParts[0];
            } else {
                player = this.getPlayer(server, nameParts, 0, true, true);
                if (nameParts.length > 1) {
                    homeName = nameParts[1];
                }
            }
        }
        try {
            if ("bed".equalsIgnoreCase(homeName) && user.isAuthorized("essentials.home.bed")) {
                if (!player.getBase().isOnline() || player.getBase() instanceof OfflinePlayerStub) {
                    throw new Exception(I18n.tl("bedOffline", new Object[0]));
                }
                PaperLib.getBedSpawnLocationAsync(player.getBase(), true).thenAccept(location -> {
                    CompletableFuture<Boolean> future = this.getNewExceptionFuture(user.getSource(), commandLabel);
                    if (location != null) {
                        UserTeleportHomeEvent event = new UserTeleportHomeEvent(user, "bed", (Location)location, UserTeleportHomeEvent.HomeType.BED);
                        server.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        future.thenAccept(success -> {
                            if (success.booleanValue()) {
                                user.sendMessage(I18n.tl("teleportHome", "bed"));
                            }
                        });
                        user.getAsyncTeleport().teleport((Location)location, charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
                    } else {
                        this.showError((CommandSender)user.getBase(), new Exception(I18n.tl("bedMissing", new Object[0])), commandLabel);
                    }
                });
                throw new NoChargeException();
            }
            this.goHome(user, player, homeName.toLowerCase(Locale.ENGLISH), charge, this.getNewExceptionFuture(user.getSource(), commandLabel));
        }
        catch (NotEnoughArgumentsException e) {
            User finalPlayer = player;
            CompletableFuture message = new CompletableFuture();
            message.thenAccept(bed -> {
                List<String> homes = finalPlayer.getHomes();
                if (homes.isEmpty() && finalPlayer.equals(user)) {
                    if (this.ess.getSettings().isSpawnIfNoHome()) {
                        UserTeleportHomeEvent event = new UserTeleportHomeEvent(user, null, bed != null ? bed : finalPlayer.getWorld().getSpawnLocation(), bed != null ? UserTeleportHomeEvent.HomeType.BED : UserTeleportHomeEvent.HomeType.SPAWN);
                        server.getPluginManager().callEvent((Event)event);
                        if (!event.isCancelled()) {
                            user.getAsyncTeleport().respawn(charge, PlayerTeleportEvent.TeleportCause.COMMAND, this.getNewExceptionFuture(user.getSource(), commandLabel));
                        }
                    } else {
                        this.showError((CommandSender)user.getBase(), new Exception(I18n.tl("noHomeSetPlayer", new Object[0])), commandLabel);
                    }
                } else if (homes.isEmpty() || !finalPlayer.hasValidHomes()) {
                    this.showError((CommandSender)user.getBase(), new Exception(I18n.tl("noHomeSetPlayer", new Object[0])), commandLabel);
                } else if (homes.size() == 1 && finalPlayer.equals(user)) {
                    try {
                        this.goHome(user, finalPlayer, homes.get(0), charge, this.getNewExceptionFuture(user.getSource(), commandLabel));
                    }
                    catch (Exception exception) {
                        this.showError((CommandSender)user.getBase(), exception, commandLabel);
                    }
                } else {
                    int count = homes.size();
                    if (user.isAuthorized("essentials.home.bed")) {
                        if (bed != null) {
                            homes.add(I18n.tl("bed", new Object[0]));
                        } else {
                            homes.add(I18n.tl("bedNull", new Object[0]));
                        }
                    }
                    user.sendMessage(I18n.tl("homes", StringUtil.joinList(homes), count, this.getHomeLimit(finalPlayer)));
                }
            });
            if (!player.getBase().isOnline() || player.getBase() instanceof OfflinePlayerStub) {
                message.complete(null);
                return;
            }
            PaperLib.getBedSpawnLocationAsync(player.getBase(), true).thenAccept(message::complete);
        }
        throw new NoChargeException();
    }

    private String getHomeLimit(User player) {
        if (!player.getBase().isOnline()) {
            return "?";
        }
        if (player.isAuthorized("essentials.sethome.multiple.unlimited")) {
            return "*";
        }
        return Integer.toString(this.ess.getSettings().getHomeLimit(player));
    }

    private void goHome(User user, User player, String home, Trade charge, CompletableFuture<Boolean> future) throws Exception {
        if (home.length() < 1) {
            throw new NotEnoughArgumentsException();
        }
        Location loc = player.getHome(home);
        if (loc == null) {
            throw new NotEnoughArgumentsException();
        }
        if (user.getWorld() != loc.getWorld() && this.ess.getSettings().isWorldHomePermissions() && !user.isAuthorized("essentials.worlds." + loc.getWorld().getName())) {
            throw new Exception(I18n.tl("noPerm", "essentials.worlds." + loc.getWorld().getName()));
        }
        UserTeleportHomeEvent event = new UserTeleportHomeEvent(user, home, loc, UserTeleportHomeEvent.HomeType.HOME);
        user.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            user.getAsyncTeleport().teleport(loc, charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
            future.thenAccept(success -> {
                if (success.booleanValue()) {
                    user.sendMessage(I18n.tl("teleportHome", home));
                }
            });
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        boolean canVisitOthers = user.isAuthorized("essentials.home.others");
        boolean canVisitBed = user.isAuthorized("essentials.home.bed");
        if (args.length == 1) {
            List<String> homes = user.getHomes();
            if (canVisitBed) {
                homes.add("bed");
            }
            if (canVisitOthers) {
                int sepIndex = args[0].indexOf(58);
                if (sepIndex < 0) {
                    this.getPlayers(server, user).forEach(player -> homes.add(player + ":"));
                } else {
                    User otherUser;
                    String namePart = args[0].substring(0, sepIndex);
                    try {
                        otherUser = this.getPlayer(server, new String[]{namePart}, 0, true, true);
                    }
                    catch (Exception ex) {
                        return homes;
                    }
                    otherUser.getHomes().forEach(home -> homes.add(namePart + ":" + home));
                    if (canVisitBed) {
                        homes.add(namePart + ":bed");
                    }
                }
            }
            return homes;
        }
        return Collections.emptyList();
    }
}

