/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.utils.FormatUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandbroadcastworld
extends EssentialsCommand {
    public Commandbroadcastworld() {
        super("broadcastworld");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        World argWorld;
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        World world = user.getWorld();
        String message = Commandbroadcastworld.getFinalArg(args, 0);
        if (args.length > 1 && this.ess.getSettings().isAllowWorldInBroadcastworld() && (argWorld = this.ess.getWorld(args[0])) != null) {
            world = argWorld;
            message = Commandbroadcastworld.getFinalArg(args, 1);
        }
        this.sendBroadcast(world, user.getDisplayName(), message);
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException("world");
        }
        World world = this.ess.getWorld(args[0]);
        if (world == null) {
            throw new Exception(I18n.tl("invalidWorld", new Object[0]));
        }
        this.sendBroadcast(world, sender.getSender().getName(), Commandbroadcastworld.getFinalArg(args, 1));
    }

    private void sendBroadcast(World world, String name, String message) throws Exception {
        if (message.isEmpty()) {
            throw new NotEnoughArgumentsException();
        }
        this.sendToWorld(world, I18n.tl("broadcast", FormatUtil.replaceFormat(message).replace("\\n", "\n"), name));
    }

    private void sendToWorld(World world, String message) {
        IText broadcast = new SimpleTextInput(message);
        Collection<Player> players = this.ess.getOnlinePlayers();
        for (Player player : players) {
            if (!player.getWorld().equals(world)) continue;
            User user = this.ess.getUser(player);
            broadcast = new KeywordReplacer(broadcast, new CommandSource((CommandSender)player), this.ess, false);
            for (String messageText : broadcast.getLines()) {
                user.sendMessage(messageText);
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 && (!sender.isPlayer() || this.ess.getSettings().isAllowWorldInBroadcastworld())) {
            ArrayList worlds = Lists.newArrayList();
            for (World world : server.getWorlds()) {
                worlds.add(world.getName());
            }
            return worlds;
        }
        return Collections.emptyList();
    }
}

