/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.config.ConfigurateUtil;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.libs.configurate.CommentedConfigurationNode;
import com.earth2me.essentials.utils.NumberUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Kits
implements IConf {
    private final IEssentials ess;
    private final EssentialsConfiguration rootConfig;
    private final Map<String, EssentialsConfiguration> kitToConfigMap = new HashMap<String, EssentialsConfiguration>();
    private final Map<String, Map<String, Object>> kitMap = new HashMap<String, Map<String, Object>>();

    public Kits(IEssentials essentials) {
        this.ess = essentials;
        this.rootConfig = new EssentialsConfiguration(new File(essentials.getDataFolder(), "kits.yml"), "/kits.yml");
        this.reloadConfig();
    }

    @Override
    public void reloadConfig() {
        this.rootConfig.load();
        this.parseKits();
    }

    public File getFile() {
        return this.rootConfig.getFile();
    }

    private void parseKit(String kitName, CommentedConfigurationNode kitSection, EssentialsConfiguration parentConfig) {
        if (kitSection.isMap()) {
            String effectiveKitName = kitName.toLowerCase(Locale.ENGLISH);
            this.kitToConfigMap.put(effectiveKitName, parentConfig);
            this.kitMap.put(effectiveKitName, ConfigurateUtil.getRawMap(kitSection));
        }
    }

    private void parseKits() {
        File[] kitsFiles;
        File kitsFolder;
        this.kitToConfigMap.clear();
        this.kitMap.clear();
        CommentedConfigurationNode fileKits = this.rootConfig.getSection("kits");
        if (fileKits != null) {
            for (Map.Entry<String, CommentedConfigurationNode> kitEntry : ConfigurateUtil.getMap(fileKits).entrySet()) {
                this.parseKit(kitEntry.getKey(), kitEntry.getValue(), this.rootConfig);
            }
        }
        if (!(kitsFolder = new File(this.ess.getDataFolder(), "kits")).exists() || !kitsFolder.isDirectory()) {
            return;
        }
        for (File kitFile : kitsFiles = kitsFolder.listFiles()) {
            if (!kitFile.getName().endsWith(".yml")) continue;
            EssentialsConfiguration kitConfig = new EssentialsConfiguration(kitFile);
            kitConfig.load();
            CommentedConfigurationNode kits = kitConfig.getSection("kits");
            if (kits == null) continue;
            for (Map.Entry<String, CommentedConfigurationNode> kitEntry : ConfigurateUtil.getMap(kits).entrySet()) {
                this.parseKit(kitEntry.getKey(), kitEntry.getValue(), kitConfig);
            }
        }
    }

    public EssentialsConfiguration getRootConfig() {
        return this.rootConfig;
    }

    public Set<String> getKitKeys() {
        return this.kitMap.keySet();
    }

    public Map<String, Object> getKit(String name) {
        if (name != null) {
            return this.kitMap.get(name.replace('.', '_').replace('/', '_'));
        }
        return null;
    }

    public String matchKit(String name) {
        if (name != null) {
            for (String kitName : this.kitMap.keySet()) {
                if (!kitName.equalsIgnoreCase(name)) continue;
                return kitName;
            }
        }
        return null;
    }

    public void addKit(String name, List<String> lines, long delay) {
        name = name.replace('.', '_').replace('/', '_').toLowerCase(Locale.ENGLISH);
        this.rootConfig.setProperty("kits." + name + ".delay", delay);
        this.rootConfig.setProperty("kits." + name + ".items", lines);
        this.parseKits();
        this.rootConfig.save();
    }

    public void removeKit(String name) {
        if (!this.kitToConfigMap.containsKey(name = name.replace('.', '_').replace('/', '_').toLowerCase(Locale.ENGLISH)) || !this.kitMap.containsKey(name)) {
            return;
        }
        EssentialsConfiguration config = this.kitToConfigMap.get(name);
        config.removeProperty("kits." + name);
        config.blockingSave();
        this.parseKits();
    }

    public String listKits(net.ess3.api.IEssentials ess, User user) throws Exception {
        try {
            StringBuilder list = new StringBuilder();
            for (String kitItem : this.kitMap.keySet()) {
                Kit kit;
                double nextUse;
                if (user == null) {
                    list.append(" ").append(I18n.capitalCase(kitItem));
                    continue;
                }
                if (!user.isAuthorized("essentials.kits." + kitItem.toLowerCase(Locale.ENGLISH))) continue;
                String cost = "";
                String name = I18n.capitalCase(kitItem);
                BigDecimal costPrice = new Trade("kit-" + kitItem.toLowerCase(Locale.ENGLISH), ess).getCommandCost(user);
                if (costPrice.signum() > 0) {
                    cost = I18n.tl("kitCost", NumberUtil.displayCurrency(costPrice, ess));
                }
                if ((nextUse = (double)(kit = new Kit(kitItem, ess)).getNextUse(user)) == -1.0 && ess.getSettings().isSkippingUsedOneTimeKitsFromKitList()) continue;
                if (nextUse != 0.0) {
                    name = I18n.tl("kitDelay", name);
                }
                list.append(" ").append(name).append(cost);
            }
            return list.toString().trim();
        }
        catch (Exception ex) {
            throw new Exception(I18n.tl("kitError", new Object[0]), ex);
        }
    }
}

