/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache;

import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.AsyncCacheLoader;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.LocalCacheFactory;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Node;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Pacer;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Ticker;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.WSS;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.WriteOrderDeque;
import org.checkerframework.checker.nullness.qual.Nullable;

class WSSW<K, V>
extends WSS<K, V> {
    static final LocalCacheFactory FACTORY = WSSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    WSSW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

