/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache;

import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.AccessOrderDeque;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.AsyncCacheLoader;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Caffeine;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Expiry;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.LocalCacheFactory;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Node;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Pacer;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Scheduler;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.Ticker;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.TimerWheel;
import com.artillexstudios.axgraves.libs.axapi.libs.caffeine.caffeine.cache.WIL;
import org.checkerframework.checker.nullness.qual.Nullable;

class WILA<K, V>
extends WIL<K, V> {
    static final LocalCacheFactory FACTORY = WILA::new;
    final Ticker ticker;
    final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    WILA(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.accessOrderWindowDeque = caffeine.evicts() || caffeine.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        return this.accessOrderWindowDeque;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

