/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.palette.slant;

import com.dfsek.terra.addons.chunkgenerator.generation.math.samplers.Sampler3D;
import com.dfsek.terra.addons.chunkgenerator.palette.PaletteHolder;
import com.dfsek.terra.addons.chunkgenerator.palette.slant.MultipleSlantHolder;
import com.dfsek.terra.addons.chunkgenerator.palette.slant.SingleSlantHolder;
import com.dfsek.terra.api.util.vector.Vector3;
import java.util.List;

public interface SlantHolder {
    public static final SlantHolder EMPTY = new SlantHolder(){

        @Override
        public double calculateSlant(Sampler3D sampler, double x, double y, double z) {
            throw new UnsupportedOperationException("Empty holder should not calculate slant");
        }

        @Override
        public boolean isAboveDepth(int depth) {
            return false;
        }

        @Override
        public boolean isInSlantThreshold(double slant) {
            return false;
        }

        @Override
        public PaletteHolder getPalette(double slant) {
            throw new UnsupportedOperationException("Empty holder cannot return a palette");
        }
    };

    public static SlantHolder of(List<Layer> layers, int slantDepth, CalculationMethod calculationMethod) {
        if (layers.isEmpty()) {
            return EMPTY;
        }
        if (layers.size() == 1) {
            return new SingleSlantHolder(layers.get(0), slantDepth, calculationMethod);
        }
        return new MultipleSlantHolder(layers, slantDepth, calculationMethod);
    }

    public double calculateSlant(Sampler3D var1, double var2, double var4, double var6);

    public boolean isAboveDepth(int var1);

    public boolean isInSlantThreshold(double var1);

    public PaletteHolder getPalette(double var1);

    public record Layer(PaletteHolder palette, double threshold) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CalculationMethod {
        DotProduct{
            private static final Vector3 DOT_PRODUCT_DIRECTION = Vector3.of((double)0.0, (double)1.0, (double)0.0);
            private static final Vector3[] DOT_PRODUCT_SAMPLE_POINTS = new Vector3[]{Vector3.of((double)0.0, (double)0.0, (double)-0.55), Vector3.of((double)0.0, (double)0.0, (double)0.55), Vector3.of((double)0.0, (double)-0.55, (double)0.0), Vector3.of((double)0.0, (double)0.55, (double)0.0), Vector3.of((double)-0.55, (double)0.0, (double)0.0), Vector3.of((double)0.55, (double)0.0, (double)0.0)};

            @Override
            public double slant(Sampler3D sampler, double x, double y, double z) {
                Vector3.Mutable normalApproximation = Vector3.Mutable.of((double)0.0, (double)0.0, (double)0.0);
                for (Vector3 point : DOT_PRODUCT_SAMPLE_POINTS) {
                    double scalar = -sampler.sample(x + point.getX(), y + point.getY(), z + point.getZ());
                    normalApproximation.add((Vector3)point.mutable().multiply(scalar));
                }
                return DOT_PRODUCT_DIRECTION.dot((Vector3)normalApproximation.normalize());
            }

            @Override
            public boolean floorToThreshold() {
                return false;
            }
        }
        ,
        Derivative{

            @Override
            public double slant(Sampler3D sampler, double x, double y, double z) {
                double baseSample = sampler.sample(x, y, z);
                double xVal1 = (sampler.sample(x + 0.55, y, z) - baseSample) / 0.55;
                double xVal2 = (sampler.sample(x - 0.55, y, z) - baseSample) / 0.55;
                double zVal1 = (sampler.sample(x, y, z + 0.55) - baseSample) / 0.55;
                double zVal2 = (sampler.sample(x, y, z - 0.55) - baseSample) / 0.55;
                double yVal1 = (sampler.sample(x, y + 0.55, z) - baseSample) / 0.55;
                double yVal2 = (sampler.sample(x, y - 0.55, z) - baseSample) / 0.55;
                return Math.sqrt((xVal2 - xVal1) * (xVal2 - xVal1) + (zVal2 - zVal1) * (zVal2 - zVal1) + (yVal2 - yVal1) * (yVal2 - yVal1));
            }

            @Override
            public boolean floorToThreshold() {
                return true;
            }
        };

        private static final double DERIVATIVE_DIST = 0.55;

        public abstract double slant(Sampler3D var1, double var2, double var4, double var6);

        public abstract boolean floorToThreshold();
    }
}

