/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.generation.math.samplers;

import com.dfsek.terra.addons.chunkgenerator.config.noise.BiomeNoiseProperties;
import com.dfsek.terra.addons.chunkgenerator.generation.math.samplers.Sampler3D;
import com.dfsek.terra.addons.chunkgenerator.lib.jafama.FastMath;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.properties.PropertyKey;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.dfsek.terra.api.world.info.WorldProperties;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;

public class SamplerProvider {
    private final Cache<WorldContext, Sampler3D> cache;
    private final int elevationSmooth;
    private final PropertyKey<BiomeNoiseProperties> noisePropertiesKey;
    private final int maxBlend;

    public SamplerProvider(Platform platform, int elevationSmooth, PropertyKey<BiomeNoiseProperties> noisePropertiesKey, int maxBlend) {
        this.cache = Caffeine.newBuilder().maximumSize((long)platform.getTerraConfig().getSamplerCache()).build();
        this.elevationSmooth = elevationSmooth;
        this.noisePropertiesKey = noisePropertiesKey;
        this.maxBlend = maxBlend;
    }

    public Sampler3D get(int x, int z, WorldProperties world, BiomeProvider provider) {
        int cx = FastMath.floorDiv(x, 16);
        int cz = FastMath.floorDiv(z, 16);
        return this.getChunk(cx, cz, world, provider);
    }

    public Sampler3D getChunk(int cx, int cz, WorldProperties world, BiomeProvider provider) {
        WorldContext context = new WorldContext(cx, cz, world.getSeed(), world.getMinHeight(), world.getMaxHeight());
        return (Sampler3D)this.cache.get((Object)context, c -> new Sampler3D(c.cx, c.cz, c.seed, c.minHeight, c.maxHeight, provider, this.elevationSmooth, this.noisePropertiesKey, this.maxBlend));
    }

    private record WorldContext(int cx, int cz, long seed, int minHeight, int maxHeight) {
    }
}

