/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.generation.math.interpolation;

import com.dfsek.terra.addons.chunkgenerator.config.noise.BiomeNoiseProperties;
import com.dfsek.terra.api.properties.PropertyKey;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;

public class ElevationInterpolator {
    private final double[][] values = new double[18][18];

    public ElevationInterpolator(long seed, int chunkX, int chunkZ, BiomeProvider provider, int smooth, PropertyKey<BiomeNoiseProperties> noisePropertiesKey) {
        int z;
        int x;
        int xOrigin = chunkX << 4;
        int zOrigin = chunkZ << 4;
        BiomeNoiseProperties[][] gens = new BiomeNoiseProperties[18 + 2 * smooth][18 + 2 * smooth];
        for (x = -1 - smooth; x <= 16 + smooth; ++x) {
            for (z = -1 - smooth; z <= 16 + smooth; ++z) {
                int bx = xOrigin + x;
                int bz = zOrigin + z;
                gens[x + 1 + smooth][z + 1 + smooth] = (BiomeNoiseProperties)provider.getBaseBiome(bx, bz, seed).orElseGet(() -> provider.getBiome(bx, 0, bz, seed)).getContext().get(noisePropertiesKey);
            }
        }
        for (x = -1; x <= 16; ++x) {
            for (z = -1; z <= 16; ++z) {
                int zi;
                int xi;
                double noise = 0.0;
                double div = 0.0;
                BiomeNoiseProperties center = gens[x + 1 + smooth][z + 1 + smooth];
                boolean same = true;
                block4: for (xi = -smooth; xi <= smooth; ++xi) {
                    for (zi = -smooth; zi <= smooth; ++zi) {
                        if (gens[x + 1 + smooth + xi][z + 1 + smooth + zi] == center) continue;
                        same = false;
                        continue block4;
                    }
                }
                if (same) {
                    this.values[x + 1][z + 1] = center.elevation().noise(seed, xOrigin + x, zOrigin + z);
                    continue;
                }
                for (xi = -smooth; xi <= smooth; ++xi) {
                    for (zi = -smooth; zi <= smooth; ++zi) {
                        BiomeNoiseProperties gen = gens[x + 1 + smooth + xi][z + 1 + smooth + zi];
                        noise += gen.elevation().noise(seed, xOrigin + x, zOrigin + z) * gen.elevationWeight();
                        div += gen.elevationWeight();
                    }
                }
                this.values[x + 1][z + 1] = noise / div;
            }
        }
    }

    public double getElevation(int x, int z) {
        return this.values[x + 1][z + 1];
    }
}

