/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.config.palette;

import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Description;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.tectonic.api.config.template.object.ObjectTemplate;
import com.dfsek.terra.addons.chunkgenerator.palette.BiomePaletteInfo;
import com.dfsek.terra.addons.chunkgenerator.palette.PaletteHolder;
import com.dfsek.terra.addons.chunkgenerator.palette.slant.SlantHolder;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.world.chunk.generation.util.Palette;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BiomePaletteTemplate
implements ObjectTemplate<BiomePaletteInfo> {
    private final Platform platform;
    @Value(value="slant")
    @Default
    @Description(value="The slant palettes to use in this biome.")
    private @Meta List<@Meta SlantHolder.Layer> slantLayers = Collections.emptyList();
    @Value(value="slant-depth")
    @Default
    @Description(value="The maximum depth at which to apply a slant palette.")
    private @Meta int slantDepth = Integer.MAX_VALUE;
    @Value(value="palette")
    @Description(value="The palettes to use in this biome.")
    private @Meta List<@Meta Map<@Meta Palette, @Meta Integer>> palettes;
    @Value(value="ocean.level")
    @Description(value="Sea level in this biome. Defaults to zero")
    @Default
    private @Meta int seaLevel = 0;
    @Value(value="ocean.palette")
    @Description(value="The palette to use for the ocean in this biome. Defaults to a blank palette.")
    @Default
    private @Meta Palette oceanPalette = new Palette(){

        public BlockState get(int layer, double x, double y, double z, long seed) {
            return BiomePaletteTemplate.this.platform.getWorldHandle().air();
        }
    };
    @Value(value="carving.update-palette")
    @Default
    private @Meta boolean updatePalette = false;
    private final SlantHolder.CalculationMethod slantCalculationMethod;

    public BiomePaletteTemplate(Platform platform, SlantHolder.CalculationMethod slantCalculationMethod) {
        this.platform = platform;
        this.slantCalculationMethod = slantCalculationMethod;
    }

    public BiomePaletteInfo get() {
        return new BiomePaletteInfo(PaletteHolder.of(this.palettes), SlantHolder.of(this.slantLayers, this.slantDepth, this.slantCalculationMethod), this.oceanPalette, this.seaLevel, this.updatePalette);
    }
}

