/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.mutator;

import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.type.BiomeMutator;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import java.util.HashSet;
import java.util.stream.Stream;

public class ReplaceMutator
implements BiomeMutator {
    private final String replaceableTag;
    private final ProbabilityCollection<BiomeDelegate> replace;
    private final NoiseSampler sampler;

    public ReplaceMutator(String replaceable, ProbabilityCollection<BiomeDelegate> replace, NoiseSampler sampler) {
        this.replaceableTag = replaceable;
        this.replace = replace;
        this.sampler = sampler;
    }

    @Override
    public BiomeDelegate mutate(BiomeMutator.ViewPoint viewPoint, double x, double z, long seed) {
        if (viewPoint.getBiome(0, 0).getTags().contains(this.replaceableTag)) {
            BiomeDelegate biome = (BiomeDelegate)this.replace.get(this.sampler, x, z, seed);
            return biome.isSelf() ? viewPoint.getBiome(0, 0) : biome;
        }
        return viewPoint.getBiome(0, 0);
    }

    @Override
    public Iterable<BiomeDelegate> getBiomes(Iterable<BiomeDelegate> biomes) {
        HashSet<BiomeDelegate> biomeSet = new HashSet<BiomeDelegate>();
        HashSet reject = new HashSet();
        biomes.forEach(biome -> {
            if (!biome.getTags().contains(this.replaceableTag)) {
                biomeSet.add((BiomeDelegate)biome);
            } else {
                reject.add(biome);
            }
        });
        biomeSet.addAll(this.replace.getContents().stream().flatMap(terraBiome -> {
            if (terraBiome.isSelf()) {
                return reject.stream();
            }
            return Stream.of(terraBiome);
        }).toList());
        return biomeSet;
    }
}

