/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.config;

import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Description;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.terra.addons.biome.pipeline.BiomePipeline;
import com.dfsek.terra.addons.biome.pipeline.BiomePipelineProvider;
import com.dfsek.terra.addons.biome.pipeline.api.stage.Stage;
import com.dfsek.terra.addons.biome.pipeline.config.BiomeProviderTemplate;
import com.dfsek.terra.addons.biome.pipeline.source.BiomeSource;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import java.util.List;

public class BiomePipelineTemplate
extends BiomeProviderTemplate {
    @Value(value="pipeline.initial-size")
    @Default
    @Description(value="The initial size of biome chunks. This value must be at least 2.\n<b>This is not the final size of biome chunks. Final chunks will be much larger</b>.\n\nIt is recommended to keep biome chunks' final size in the range of [50, 300]\nto prevent performance issues. To calculate the size of biome chunks, simply\ntake initial-size and for each expand stage, multiply the running value by 2\nand subtract 1. (The size is also printed to the server console if you\nhave debug mode enabled)")
    private @Meta int initialSize = 2;
    @Value(value="pipeline.source")
    @Description(value="The Biome Source to use for initial population of biomes.")
    private @Meta BiomeSource source;
    @Value(value="pipeline.stages")
    @Description(value="A list of pipeline stages to apply to the result of #source")
    private @Meta List<@Meta Stage> stages;

    public BiomeProvider get() {
        BiomePipeline.BiomePipelineBuilder biomePipelineBuilder = new BiomePipeline.BiomePipelineBuilder(this.initialSize);
        this.stages.forEach(biomePipelineBuilder::addStage);
        BiomePipeline pipeline = biomePipelineBuilder.build(this.source);
        return new BiomePipelineProvider(pipeline, this.resolution, this.blend, this.blendAmp);
    }
}

