/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline;

import com.dfsek.tectonic.api.config.template.object.ObjectTemplate;
import com.dfsek.tectonic.api.loader.type.TypeLoader;
import com.dfsek.terra.addons.biome.pipeline.api.delegate.BiomeDelegate;
import com.dfsek.terra.addons.biome.pipeline.api.stage.Stage;
import com.dfsek.terra.addons.biome.pipeline.config.BiomeDelegateLoader;
import com.dfsek.terra.addons.biome.pipeline.config.BiomePipelineTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.SamplerSourceTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.stage.expander.ExpanderStageTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.stage.mutator.BorderListMutatorTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.stage.mutator.BorderMutatorTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.stage.mutator.ReplaceListMutatorTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.stage.mutator.ReplaceMutatorTemplate;
import com.dfsek.terra.addons.biome.pipeline.config.stage.mutator.SmoothMutatorTemplate;
import com.dfsek.terra.addons.biome.pipeline.source.BiomeSource;
import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.event.events.config.pack.ConfigPackPostLoadEvent;
import com.dfsek.terra.api.event.events.config.pack.ConfigPackPreLoadEvent;
import com.dfsek.terra.api.event.functional.FunctionalEventHandler;
import com.dfsek.terra.api.inject.annotations.Inject;
import com.dfsek.terra.api.registry.CheckedRegistry;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.api.util.reflection.TypeKey;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiomePipelineAddon
implements AddonInitializer {
    private static final Logger logger = LoggerFactory.getLogger(BiomePipelineAddon.class);
    public static final TypeKey<Supplier<ObjectTemplate<BiomeSource>>> SOURCE_REGISTRY_KEY = new TypeKey<Supplier<ObjectTemplate<BiomeSource>>>(){};
    public static final TypeKey<Supplier<ObjectTemplate<Stage>>> STAGE_REGISTRY_KEY = new TypeKey<Supplier<ObjectTemplate<Stage>>>(){};
    public static final TypeKey<Supplier<ObjectTemplate<BiomeProvider>>> PROVIDER_REGISTRY_KEY = new TypeKey<Supplier<ObjectTemplate<BiomeProvider>>>(){};
    @Inject
    private Platform platform;
    @Inject
    private BaseAddon addon;

    public void initialize() {
        ((FunctionalEventHandler)this.platform.getEventManager().getHandler(FunctionalEventHandler.class)).register(this.addon, ConfigPackPreLoadEvent.class).then(event -> {
            CheckedRegistry providerRegistry = event.getPack().getOrCreateRegistry(PROVIDER_REGISTRY_KEY);
            providerRegistry.register(this.addon.key("PIPELINE"), BiomePipelineTemplate::new);
        }).then(event -> {
            CheckedRegistry sourceRegistry = event.getPack().getOrCreateRegistry(SOURCE_REGISTRY_KEY);
            sourceRegistry.register(this.addon.key("SAMPLER"), SamplerSourceTemplate::new);
        }).then(event -> {
            CheckedRegistry stageRegistry = event.getPack().getOrCreateRegistry(STAGE_REGISTRY_KEY);
            stageRegistry.register(this.addon.key("FRACTAL_EXPAND"), ExpanderStageTemplate::new);
            stageRegistry.register(this.addon.key("SMOOTH"), SmoothMutatorTemplate::new);
            stageRegistry.register(this.addon.key("REPLACE"), ReplaceMutatorTemplate::new);
            stageRegistry.register(this.addon.key("REPLACE_LIST"), ReplaceListMutatorTemplate::new);
            stageRegistry.register(this.addon.key("BORDER"), BorderMutatorTemplate::new);
            stageRegistry.register(this.addon.key("BORDER_LIST"), BorderListMutatorTemplate::new);
        }).failThrough();
        ((FunctionalEventHandler)this.platform.getEventManager().getHandler(FunctionalEventHandler.class)).register(this.addon, ConfigPackPostLoadEvent.class).then(event -> {
            Registry biomeRegistry = event.getPack().getRegistry(Biome.class);
            event.getPack().applyLoader(BiomeDelegate.class, (TypeLoader)new BiomeDelegateLoader((Registry<Biome>)biomeRegistry));
        });
        logger.warn("The biome-provider-pipeline addon is deprecated and scheduled for removal in Terra 7.0. It is recommended to use the biome-provider-pipeline-v2 addon for future pack development instead.");
    }
}

