/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.gui.component.components;

import com.artillexstudios.axgraves.libs.gui.component.ReactiveGuiComponent;
import com.artillexstudios.axgraves.libs.gui.container.GuiContainer;
import com.artillexstudios.axgraves.libs.gui.item.GuiItem;
import com.artillexstudios.axgraves.libs.gui.item.items.SimpleGuiItem;
import com.artillexstudios.axgraves.libs.gui.layout.GuiLayout;
import com.artillexstudios.axgraves.libs.gui.slot.Slot;
import dev.triumphteam.nova.MutableState;
import dev.triumphteam.nova.State;
import dev.triumphteam.nova.builtin.SimpleMutableState;
import dev.triumphteam.nova.policy.StateMutationPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PaginatedComponent<P, I>
implements ReactiveGuiComponent<P, I> {
    private final Slot back;
    private final I backItem;
    private final Slot forward;
    private final I forwardItem;
    private final List<GuiItem<P, I>> items;
    private final GuiLayout layout;
    private final MutableState<Integer> pageState = new SimpleMutableState((Object)0, StateMutationPolicy.StructuralEquality.INSTANCE);

    public PaginatedComponent(@NotNull Slot back, @NotNull I backItem, @NotNull Slot forward, @NotNull I forwardItem, @NotNull List<GuiItem<P, I>> items, @NotNull GuiLayout layout) {
        this.back = back;
        this.backItem = backItem;
        this.forward = forward;
        this.forwardItem = forwardItem;
        this.items = items;
        this.layout = layout;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull State> states() {
        return List.of(this.pageState);
    }

    @Override
    public void render(@NotNull GuiContainer<P, I> container, @NotNull P player) {
        Integer page = (Integer)this.pageState.getValue();
        container.set(this.back, new SimpleGuiItem<Object, I>(this.backItem, (ignored, context) -> this.pageState.setValue((Object)(page - 1))));
        container.set(this.forward, new SimpleGuiItem<Object, I>(this.forwardItem, (ignored, context) -> this.pageState.setValue((Object)(page + 1))));
        List<Slot> slots = this.layout.generatePositions();
        int size = slots.size();
        int offset = page * size;
        for (int i = 0; i < size; ++i) {
            int offsetSlot = offset + i;
            Slot slot = slots.get(i);
            GuiItem<P, I> item = this.items.get(offsetSlot);
            container.set(slot, item);
        }
    }
}

