/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.gui;

import com.artillexstudios.axgraves.libs.gui.GuiView;
import com.artillexstudios.axgraves.libs.gui.click.handler.ClickHandler;
import com.artillexstudios.axgraves.libs.gui.click.processor.ClickProcessor;
import com.artillexstudios.axgraves.libs.gui.component.GuiComponent;
import com.artillexstudios.axgraves.libs.gui.component.RenderedComponent;
import com.artillexstudios.axgraves.libs.gui.component.StatefulGuiComponent;
import com.artillexstudios.axgraves.libs.gui.component.renderer.GuiComponentRenderer;
import com.artillexstudios.axgraves.libs.gui.container.type.GuiContainerType;
import com.artillexstudios.axgraves.libs.gui.item.RenderedGuiItem;
import dev.triumphteam.nova.Stateful;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuiView<P, I>
implements GuiView<P, I>,
Stateful {
    private final P viewer;
    private final List<GuiComponent<P, I>> components;
    private final GuiComponentRenderer<P, I> renderer;
    private final ClickHandler<P> defaultClickHandler;
    private final GuiContainerType containerType;
    private final ClickProcessor<P, I> clickProcessor;
    private final Map<GuiComponent<P, I>, RenderedComponent<P, I>> renderedComponents = new ConcurrentHashMap<GuiComponent<P, I>, RenderedComponent<P, I>>();
    private final Map<Integer, RenderedGuiItem<P, I>> allRenderedItems = new ConcurrentHashMap<Integer, RenderedGuiItem<P, I>>();

    public AbstractGuiView(@NotNull P viewer, @NotNull @NotNull List<@NotNull GuiComponent<P, I>> components, @NotNull GuiContainerType containerType, @NotNull GuiComponentRenderer<P, I> renderer, @NotNull ClickHandler<P> defaultClickHandler, @NotNull ClickProcessor<P, I> clickProcessor) {
        this.viewer = viewer;
        this.components = components;
        this.containerType = containerType;
        this.renderer = renderer;
        this.defaultClickHandler = defaultClickHandler;
        this.clickProcessor = clickProcessor;
    }

    @NotNull
    public P viewer() {
        return this.viewer;
    }

    @NotNull
    public abstract String viewerName();

    @NotNull
    public abstract UUID viewerUuid();

    protected abstract void clearSlot(int var1);

    protected abstract void populateInventory(@NotNull @NotNull Map<Integer, @NotNull RenderedGuiItem<P, I>> var1);

    protected void setup() {
        this.components.forEach(component -> {
            if (component instanceof StatefulGuiComponent) {
                ((StatefulGuiComponent)component).states().forEach(state -> state.addListener((Stateful)this, () -> this.renderer.renderComponent(this.viewer, (GuiComponent<P, I>)component, this)));
            }
            this.renderer.renderComponent(this.viewer, (GuiComponent<P, I>)component, this);
        });
    }

    public void completeRendered(@NotNull RenderedComponent<P, I> renderedComponent) {
        GuiComponent<P, I> ownerComponent = renderedComponent.component();
        RenderedComponent<P, I> existing = this.renderedComponents.get(ownerComponent);
        if (existing != null) {
            existing.renderedItems().forEach((slot, ignored) -> {
                this.clearSlot((int)slot);
                this.allRenderedItems.remove(slot);
            });
        }
        this.renderedComponents.put(ownerComponent, renderedComponent);
        Map<Integer, RenderedGuiItem<P, I>> renderedItems = renderedComponent.renderedItems();
        this.allRenderedItems.putAll(renderedItems);
        this.populateInventory(renderedItems);
    }

    @NotNull
    public ClickProcessor<P, I> getClickProcessor() {
        return this.clickProcessor;
    }

    @Nullable
    public RenderedGuiItem<P, I> getItem(int slot) {
        return this.allRenderedItems.get(slot);
    }

    @NotNull
    public ClickHandler<P> getDefaultClickHandler() {
        return this.defaultClickHandler;
    }

    @NotNull
    public GuiContainerType getContainerType() {
        return this.containerType;
    }
}

