/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.utils.updatechecker.sources;

import com.artillexstudios.axgraves.libs.axapi.utils.updatechecker.ArtifactVersion;
import com.artillexstudios.axgraves.libs.axapi.utils.updatechecker.Changelog;
import com.artillexstudios.axgraves.libs.axapi.utils.updatechecker.UpdateCheck;
import com.artillexstudios.axgraves.libs.axapi.utils.updatechecker.UpdateCheckResult;
import com.artillexstudios.axgraves.libs.axapi.utils.updatechecker.sources.UpdateCheckSource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public final class PolymartUpdateCheckSource
implements UpdateCheckSource {
    private final int id;

    public PolymartUpdateCheckSource(int id) {
        this.id = id;
    }

    @Override
    public UpdateCheck check(ArtifactVersion current) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.polymart.org/v1/getResourceUpdates/?pretty_print_result=1&resource_id=" + this.id + "&start=0&limit=3000")).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return new UpdateCheck(UpdateCheckResult.FAILED, current, List.of());
            }
            String body = response.body().toString();
            ArrayList<Changelog> changelogs = new ArrayList<Changelog>();
            JsonObject obj = new Gson().fromJson(body, JsonObject.class);
            obj = obj.get("response").getAsJsonObject();
            JsonArray updates = obj.get("updates").getAsJsonArray();
            ArtifactVersion latest = new ArtifactVersion(updates.get(0).getAsJsonObject().get("version").getAsString());
            for (JsonElement jsonElement : updates) {
                JsonObject object = jsonElement.getAsJsonObject();
                ArtifactVersion version = new ArtifactVersion(object.get("version").getAsString());
                if (version.version() > current.version()) {
                    changelogs.add(new Changelog(version, object.get("description").getAsString()));
                    continue;
                }
                if (version.version() != current.version()) continue;
                break;
            }
            return new UpdateCheck(latest.version() > current.version() ? UpdateCheckResult.UPDATE_AVAILABLE : (latest.version() == current.version() ? UpdateCheckResult.UP_TO_DATE : UpdateCheckResult.DEV_VERSION), latest, changelogs);
        }
        catch (Exception e) {
            return new UpdateCheck(UpdateCheckResult.FAILED, current, List.of(), e);
        }
    }
}

