/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axgraves.libs.axapi.utils;

import com.artillexstudios.axgraves.libs.axapi.utils.FileLogger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public final class LogUtils {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final FileLogger logger = new FileLogger("logs");

    public static void debug(String message) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message);
        logger.log(message);
    }

    public static void debug(String message, Object object) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, object);
        String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
        logger.log(formatted);
    }

    public static void debug(String message, Object object, Object object2) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, object, object2);
        String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
        formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object2 == null ? "null" : object2.toString()), (int)1);
        logger.log(formatted);
    }

    public static void debug(String message, Object object, Object object2, Object object3) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, new Object[]{object, object2, object3});
        String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
        formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object2 == null ? "null" : object2.toString()), (int)1);
        formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object3 == null ? "null" : object3.toString()), (int)1);
        logger.log(formatted);
    }

    public static void debug(String message, Object object, Object object2, Object object3, Object object4) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, new Object[]{object, object2, object3, object4});
        String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
        formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object2 == null ? "null" : object2.toString()), (int)1);
        formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object3 == null ? "null" : object3.toString()), (int)1);
        formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object4 == null ? "null" : object4.toString()), (int)1);
        logger.log(formatted);
    }

    public static void debug(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, arguments);
        String formatted = message;
        for (Object argument : arguments) {
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(argument == null ? "null" : argument.toString()), (int)1);
        }
        logger.log(formatted);
    }

    public static void warn(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).warn(message, arguments);
    }

    public static void error(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).error(message, arguments);
    }

    public static void info(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, arguments);
    }
}

